/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.EC2Response;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfig;
import software.amazon.awssdk.services.ec2.model.SpotFleetRequestConfigSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeSpotFleetRequestsResponse
extends EC2Response
implements ToCopyableBuilder<Builder, DescribeSpotFleetRequestsResponse> {
    private final String nextToken;
    private final List<SpotFleetRequestConfig> spotFleetRequestConfigs;

    private DescribeSpotFleetRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.spotFleetRequestConfigs = builder.spotFleetRequestConfigs;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<SpotFleetRequestConfig> spotFleetRequestConfigs() {
        return this.spotFleetRequestConfigs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.spotFleetRequestConfigs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSpotFleetRequestsResponse)) {
            return false;
        }
        DescribeSpotFleetRequestsResponse other = (DescribeSpotFleetRequestsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.spotFleetRequestConfigs(), other.spotFleetRequestConfigs());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSpotFleetRequestsResponse").add("NextToken", (Object)this.nextToken()).add("SpotFleetRequestConfigs", this.spotFleetRequestConfigs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "SpotFleetRequestConfigs": {
                return Optional.of(clazz.cast(this.spotFleetRequestConfigs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SpotFleetRequestConfig> spotFleetRequestConfigs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSpotFleetRequestsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.spotFleetRequestConfigs(model.spotFleetRequestConfigs);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<SpotFleetRequestConfig.Builder> getSpotFleetRequestConfigs() {
            return this.spotFleetRequestConfigs != null ? (Collection)this.spotFleetRequestConfigs.stream().map(SpotFleetRequestConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder spotFleetRequestConfigs(Collection<SpotFleetRequestConfig> spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs = SpotFleetRequestConfigSetCopier.copy(spotFleetRequestConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestConfigs(SpotFleetRequestConfig ... spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs(Arrays.asList(spotFleetRequestConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder spotFleetRequestConfigs(Consumer<SpotFleetRequestConfig.Builder> ... spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs(Stream.of(spotFleetRequestConfigs).map(c -> (SpotFleetRequestConfig)((SpotFleetRequestConfig.Builder)SpotFleetRequestConfig.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSpotFleetRequestConfigs(Collection<SpotFleetRequestConfig.BuilderImpl> spotFleetRequestConfigs) {
            this.spotFleetRequestConfigs = SpotFleetRequestConfigSetCopier.copyFromBuilder(spotFleetRequestConfigs);
        }

        @Override
        public DescribeSpotFleetRequestsResponse build() {
            return new DescribeSpotFleetRequestsResponse(this);
        }
    }

    public static interface Builder
    extends EC2Response.Builder,
    CopyableBuilder<Builder, DescribeSpotFleetRequestsResponse> {
        public Builder nextToken(String var1);

        public Builder spotFleetRequestConfigs(Collection<SpotFleetRequestConfig> var1);

        public Builder spotFleetRequestConfigs(SpotFleetRequestConfig ... var1);

        public Builder spotFleetRequestConfigs(Consumer<SpotFleetRequestConfig.Builder> ... var1);
    }
}

