/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ec2.model.EC2Request;
import software.amazon.awssdk.services.ec2.model.Ipv6AddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AssignIpv6AddressesRequest
extends EC2Request
implements ToCopyableBuilder<Builder, AssignIpv6AddressesRequest> {
    private final Integer ipv6AddressCount;
    private final List<String> ipv6Addresses;
    private final String networkInterfaceId;

    private AssignIpv6AddressesRequest(BuilderImpl builder) {
        super(builder);
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.networkInterfaceId = builder.networkInterfaceId;
    }

    public Integer ipv6AddressCount() {
        return this.ipv6AddressCount;
    }

    public List<String> ipv6Addresses() {
        return this.ipv6Addresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipv6Addresses());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssignIpv6AddressesRequest)) {
            return false;
        }
        AssignIpv6AddressesRequest other = (AssignIpv6AddressesRequest)((Object)obj);
        return Objects.equals(this.ipv6AddressCount(), other.ipv6AddressCount()) && Objects.equals(this.ipv6Addresses(), other.ipv6Addresses()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId());
    }

    public String toString() {
        return ToString.builder((String)"AssignIpv6AddressesRequest").add("Ipv6AddressCount", (Object)this.ipv6AddressCount()).add("Ipv6Addresses", this.ipv6Addresses()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ipv6AddressCount": {
                return Optional.of(clazz.cast(this.ipv6AddressCount()));
            }
            case "Ipv6Addresses": {
                return Optional.of(clazz.cast(this.ipv6Addresses()));
            }
            case "NetworkInterfaceId": {
                return Optional.of(clazz.cast(this.networkInterfaceId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EC2Request.BuilderImpl
    implements Builder {
        private Integer ipv6AddressCount;
        private List<String> ipv6Addresses;
        private String networkInterfaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssignIpv6AddressesRequest model) {
            super(model);
            this.ipv6AddressCount(model.ipv6AddressCount);
            this.ipv6Addresses(model.ipv6Addresses);
            this.networkInterfaceId(model.networkInterfaceId);
        }

        public final Integer getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        public final Collection<String> getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        public final Builder ipv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(String ... ipv6Addresses) {
            this.ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        public final void setIpv6Addresses(Collection<String> ipv6Addresses) {
            this.ipv6Addresses = Ipv6AddressListCopier.copy(ipv6Addresses);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AssignIpv6AddressesRequest build() {
            return new AssignIpv6AddressesRequest(this);
        }
    }

    public static interface Builder
    extends EC2Request.Builder,
    CopyableBuilder<Builder, AssignIpv6AddressesRequest> {
        public Builder ipv6AddressCount(Integer var1);

        public Builder ipv6Addresses(Collection<String> var1);

        public Builder ipv6Addresses(String ... var1);

        public Builder networkInterfaceId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

