/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.util.StringUtils;

public class StopInstancesRequestMarshaller
implements Marshaller<Request<StopInstancesRequest>, StopInstancesRequest> {
    public Request<StopInstancesRequest> marshall(StopInstancesRequest stopInstancesRequest) {
        if (stopInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)stopInstancesRequest, "EC2Client");
        request.addParameter("Action", "StopInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList stopInstancesRequestInstanceIdsList = (SdkInternalList)stopInstancesRequest.instanceIds();
        if (!stopInstancesRequestInstanceIdsList.isEmpty() || !stopInstancesRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String stopInstancesRequestInstanceIdsListValue : stopInstancesRequestInstanceIdsList) {
                if (stopInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)stopInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (stopInstancesRequest.force() != null) {
            request.addParameter("Force", StringUtils.fromBoolean((Boolean)stopInstancesRequest.force()));
        }
        return request;
    }
}

