/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.StaleIpPermission;
import software.amazon.awssdk.services.ec2.model.StaleSecurityGroup;
import software.amazon.awssdk.services.ec2.transform.StaleIpPermissionUnmarshaller;

public class StaleSecurityGroupUnmarshaller
implements Unmarshaller<StaleSecurityGroup, StaxUnmarshallerContext> {
    private static StaleSecurityGroupUnmarshaller INSTANCE;

    public StaleSecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StaleSecurityGroup.Builder staleSecurityGroup = StaleSecurityGroup.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("description", targetDepth)) {
                    staleSecurityGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupId", targetDepth)) {
                    staleSecurityGroup.groupId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupName", targetDepth)) {
                    staleSecurityGroup.groupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("staleIpPermissions", targetDepth)) {
                    staleSecurityGroup.staleIpPermissions(new ArrayList<StaleIpPermission>());
                    continue;
                }
                if (context.testExpression("staleIpPermissions/item", targetDepth)) {
                    staleSecurityGroup.staleIpPermissions(StaleIpPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("staleIpPermissionsEgress", targetDepth)) {
                    staleSecurityGroup.staleIpPermissionsEgress(new ArrayList<StaleIpPermission>());
                    continue;
                }
                if (context.testExpression("staleIpPermissionsEgress/item", targetDepth)) {
                    staleSecurityGroup.staleIpPermissionsEgress(StaleIpPermissionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpcId", targetDepth)) continue;
                staleSecurityGroup.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StaleSecurityGroup)staleSecurityGroup.build();
    }

    public static StaleSecurityGroupUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StaleSecurityGroupUnmarshaller();
        }
        return INSTANCE;
    }
}

