/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.ScheduledInstancesNetworkInterface;
import software.amazon.awssdk.services.ec2.transform.ScheduledInstancesBlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ScheduledInstancesIamInstanceProfileUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ScheduledInstancesMonitoringUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ScheduledInstancesNetworkInterfaceUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ScheduledInstancesPlacementUnmarshaller;

public class ScheduledInstancesLaunchSpecificationUnmarshaller
implements Unmarshaller<ScheduledInstancesLaunchSpecification, StaxUnmarshallerContext> {
    private static ScheduledInstancesLaunchSpecificationUnmarshaller INSTANCE;

    public ScheduledInstancesLaunchSpecification unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ScheduledInstancesLaunchSpecification.Builder scheduledInstancesLaunchSpecification = ScheduledInstancesLaunchSpecification.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("BlockDeviceMapping", targetDepth)) {
                    scheduledInstancesLaunchSpecification.blockDeviceMappings(new ArrayList<ScheduledInstancesBlockDeviceMapping>());
                    continue;
                }
                if (context.testExpression("BlockDeviceMapping/BlockDeviceMapping", targetDepth)) {
                    scheduledInstancesLaunchSpecification.blockDeviceMappings(ScheduledInstancesBlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EbsOptimized", targetDepth)) {
                    scheduledInstancesLaunchSpecification.ebsOptimized(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IamInstanceProfile", targetDepth)) {
                    scheduledInstancesLaunchSpecification.iamInstanceProfile(ScheduledInstancesIamInstanceProfileUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ImageId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    scheduledInstancesLaunchSpecification.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KernelId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("KeyName", targetDepth)) {
                    scheduledInstancesLaunchSpecification.keyName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Monitoring", targetDepth)) {
                    scheduledInstancesLaunchSpecification.monitoring(ScheduledInstancesMonitoringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NetworkInterface", targetDepth)) {
                    scheduledInstancesLaunchSpecification.networkInterfaces(new ArrayList<ScheduledInstancesNetworkInterface>());
                    continue;
                }
                if (context.testExpression("NetworkInterface/NetworkInterface", targetDepth)) {
                    scheduledInstancesLaunchSpecification.networkInterfaces(ScheduledInstancesNetworkInterfaceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Placement", targetDepth)) {
                    scheduledInstancesLaunchSpecification.placement(ScheduledInstancesPlacementUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("RamdiskId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SecurityGroupId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.securityGroupIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SecurityGroupId/SecurityGroupId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.securityGroupIds(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubnetId", targetDepth)) {
                    scheduledInstancesLaunchSpecification.subnetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("UserData", targetDepth)) continue;
                scheduledInstancesLaunchSpecification.userData(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ScheduledInstancesLaunchSpecification)scheduledInstancesLaunchSpecification.build();
    }

    public static ScheduledInstancesLaunchSpecificationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ScheduledInstancesLaunchSpecificationUnmarshaller();
        }
        return INSTANCE;
    }
}

