/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.PropagatingVgw;
import software.amazon.awssdk.services.ec2.model.Route;
import software.amazon.awssdk.services.ec2.model.RouteTable;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociation;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.PropagatingVgwUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RouteTableAssociationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.RouteUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class RouteTableUnmarshaller
implements Unmarshaller<RouteTable, StaxUnmarshallerContext> {
    private static RouteTableUnmarshaller INSTANCE;

    public RouteTable unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        RouteTable.Builder routeTable = RouteTable.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("associationSet", targetDepth)) {
                    routeTable.associations(new ArrayList<RouteTableAssociation>());
                    continue;
                }
                if (context.testExpression("associationSet/item", targetDepth)) {
                    routeTable.associations(RouteTableAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("propagatingVgwSet", targetDepth)) {
                    routeTable.propagatingVgws(new ArrayList<PropagatingVgw>());
                    continue;
                }
                if (context.testExpression("propagatingVgwSet/item", targetDepth)) {
                    routeTable.propagatingVgws(PropagatingVgwUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("routeTableId", targetDepth)) {
                    routeTable.routeTableId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("routeSet", targetDepth)) {
                    routeTable.routes(new ArrayList<Route>());
                    continue;
                }
                if (context.testExpression("routeSet/item", targetDepth)) {
                    routeTable.routes(RouteUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    routeTable.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    routeTable.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpcId", targetDepth)) continue;
                routeTable.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (RouteTable)routeTable.build();
    }

    public static RouteTableUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new RouteTableUnmarshaller();
        }
        return INSTANCE;
    }
}

