/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.util.StringUtils;

public class RevokeSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<RevokeSecurityGroupIngressRequest>, RevokeSecurityGroupIngressRequest> {
    public Request<RevokeSecurityGroupIngressRequest> marshall(RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest) {
        SdkInternalList revokeSecurityGroupIngressRequestIpPermissionsList;
        if (revokeSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)revokeSecurityGroupIngressRequest, "EC2Client");
        request.addParameter("Action", "RevokeSecurityGroupIngress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSecurityGroupIngressRequest.cidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)revokeSecurityGroupIngressRequest.cidrIp()));
        }
        if (revokeSecurityGroupIngressRequest.fromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)revokeSecurityGroupIngressRequest.fromPort()));
        }
        if (revokeSecurityGroupIngressRequest.groupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)revokeSecurityGroupIngressRequest.groupId()));
        }
        if (revokeSecurityGroupIngressRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)revokeSecurityGroupIngressRequest.groupName()));
        }
        if (!(revokeSecurityGroupIngressRequestIpPermissionsList = (SdkInternalList)revokeSecurityGroupIngressRequest.ipPermissions()).isEmpty() || !revokeSecurityGroupIngressRequestIpPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission revokeSecurityGroupIngressRequestIpPermissionsListValue : revokeSecurityGroupIngressRequestIpPermissionsList) {
                SdkInternalList ipPermissionIpv4RangesList;
                SdkInternalList ipPermissionUserIdGroupPairsList;
                SdkInternalList ipPermissionPrefixListIdsList;
                SdkInternalList ipPermissionIpv6RangesList;
                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.fromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)revokeSecurityGroupIngressRequestIpPermissionsListValue.fromPort()));
                }
                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.ipProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)revokeSecurityGroupIngressRequestIpPermissionsListValue.ipProtocol()));
                }
                if (!(ipPermissionIpv6RangesList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.ipv6Ranges()).isEmpty() || !ipPermissionIpv6RangesList.isAutoConstruct()) {
                    int ipv6RangesListIndex = 1;
                    for (Object ipPermissionIpv6RangesListValue : ipPermissionIpv6RangesList) {
                        if (((Ipv6Range)ipPermissionIpv6RangesListValue).cidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex + ".CidrIpv6", StringUtils.fromString((String)((Ipv6Range)ipPermissionIpv6RangesListValue).cidrIpv6()));
                        }
                        ++ipv6RangesListIndex;
                    }
                }
                if (!(ipPermissionPrefixListIdsList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.prefixListIds()).isEmpty() || !ipPermissionPrefixListIdsList.isAutoConstruct()) {
                    Object ipPermissionIpv6RangesListValue;
                    int prefixListIdsListIndex = 1;
                    ipPermissionIpv6RangesListValue = ipPermissionPrefixListIdsList.iterator();
                    while (ipPermissionIpv6RangesListValue.hasNext()) {
                        PrefixListId ipPermissionPrefixListIdsListValue = (PrefixListId)ipPermissionIpv6RangesListValue.next();
                        if (ipPermissionPrefixListIdsListValue.prefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)ipPermissionPrefixListIdsListValue.prefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                if (revokeSecurityGroupIngressRequestIpPermissionsListValue.toPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)revokeSecurityGroupIngressRequestIpPermissionsListValue.toPort()));
                }
                if (!(ipPermissionUserIdGroupPairsList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.userIdGroupPairs()).isEmpty() || !ipPermissionUserIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (UserIdGroupPair ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {
                        if (ipPermissionUserIdGroupPairsListValue.groupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.groupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupName()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.peeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.peeringStatus()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.userId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.userId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipPermissionIpv4RangesList = (SdkInternalList)revokeSecurityGroupIngressRequestIpPermissionsListValue.ipv4Ranges()).isEmpty() || !ipPermissionIpv4RangesList.isAutoConstruct()) {
                    int ipv4RangesListIndex = 1;
                    for (IpRange ipPermissionIpv4RangesListValue : ipPermissionIpv4RangesList) {
                        if (ipPermissionIpv4RangesListValue.cidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".CidrIp", StringUtils.fromString((String)ipPermissionIpv4RangesListValue.cidrIp()));
                        }
                        ++ipv4RangesListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        if (revokeSecurityGroupIngressRequest.ipProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)revokeSecurityGroupIngressRequest.ipProtocol()));
        }
        if (revokeSecurityGroupIngressRequest.sourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)revokeSecurityGroupIngressRequest.sourceSecurityGroupName()));
        }
        if (revokeSecurityGroupIngressRequest.sourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)revokeSecurityGroupIngressRequest.sourceSecurityGroupOwnerId()));
        }
        if (revokeSecurityGroupIngressRequest.toPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)revokeSecurityGroupIngressRequest.toPort()));
        }
        return request;
    }
}

