/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.RevokeSecurityGroupEgressRequest;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.util.StringUtils;

public class RevokeSecurityGroupEgressRequestMarshaller
implements Marshaller<Request<RevokeSecurityGroupEgressRequest>, RevokeSecurityGroupEgressRequest> {
    public Request<RevokeSecurityGroupEgressRequest> marshall(RevokeSecurityGroupEgressRequest revokeSecurityGroupEgressRequest) {
        SdkInternalList revokeSecurityGroupEgressRequestIpPermissionsList;
        if (revokeSecurityGroupEgressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)revokeSecurityGroupEgressRequest, "EC2Client");
        request.addParameter("Action", "RevokeSecurityGroupEgress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSecurityGroupEgressRequest.groupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.groupId()));
        }
        if (!(revokeSecurityGroupEgressRequestIpPermissionsList = (SdkInternalList)revokeSecurityGroupEgressRequest.ipPermissions()).isEmpty() || !revokeSecurityGroupEgressRequestIpPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission revokeSecurityGroupEgressRequestIpPermissionsListValue : revokeSecurityGroupEgressRequestIpPermissionsList) {
                SdkInternalList ipPermissionIpv4RangesList;
                SdkInternalList ipPermissionUserIdGroupPairsList;
                SdkInternalList ipPermissionPrefixListIdsList;
                SdkInternalList ipPermissionIpv6RangesList;
                if (revokeSecurityGroupEgressRequestIpPermissionsListValue.fromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequestIpPermissionsListValue.fromPort()));
                }
                if (revokeSecurityGroupEgressRequestIpPermissionsListValue.ipProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)revokeSecurityGroupEgressRequestIpPermissionsListValue.ipProtocol()));
                }
                if (!(ipPermissionIpv6RangesList = (SdkInternalList)revokeSecurityGroupEgressRequestIpPermissionsListValue.ipv6Ranges()).isEmpty() || !ipPermissionIpv6RangesList.isAutoConstruct()) {
                    int ipv6RangesListIndex = 1;
                    for (Object ipPermissionIpv6RangesListValue : ipPermissionIpv6RangesList) {
                        if (((Ipv6Range)ipPermissionIpv6RangesListValue).cidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex + ".CidrIpv6", StringUtils.fromString((String)((Ipv6Range)ipPermissionIpv6RangesListValue).cidrIpv6()));
                        }
                        ++ipv6RangesListIndex;
                    }
                }
                if (!(ipPermissionPrefixListIdsList = (SdkInternalList)revokeSecurityGroupEgressRequestIpPermissionsListValue.prefixListIds()).isEmpty() || !ipPermissionPrefixListIdsList.isAutoConstruct()) {
                    Object ipPermissionIpv6RangesListValue;
                    int prefixListIdsListIndex = 1;
                    ipPermissionIpv6RangesListValue = ipPermissionPrefixListIdsList.iterator();
                    while (ipPermissionIpv6RangesListValue.hasNext()) {
                        PrefixListId ipPermissionPrefixListIdsListValue = (PrefixListId)ipPermissionIpv6RangesListValue.next();
                        if (ipPermissionPrefixListIdsListValue.prefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)ipPermissionPrefixListIdsListValue.prefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                if (revokeSecurityGroupEgressRequestIpPermissionsListValue.toPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequestIpPermissionsListValue.toPort()));
                }
                if (!(ipPermissionUserIdGroupPairsList = (SdkInternalList)revokeSecurityGroupEgressRequestIpPermissionsListValue.userIdGroupPairs()).isEmpty() || !ipPermissionUserIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (UserIdGroupPair ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {
                        if (ipPermissionUserIdGroupPairsListValue.groupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.groupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupName()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.peeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.peeringStatus()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.userId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.userId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipPermissionIpv4RangesList = (SdkInternalList)revokeSecurityGroupEgressRequestIpPermissionsListValue.ipv4Ranges()).isEmpty() || !ipPermissionIpv4RangesList.isAutoConstruct()) {
                    int ipv4RangesListIndex = 1;
                    for (IpRange ipPermissionIpv4RangesListValue : ipPermissionIpv4RangesList) {
                        if (ipPermissionIpv4RangesListValue.cidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".CidrIp", StringUtils.fromString((String)ipPermissionIpv4RangesListValue.cidrIp()));
                        }
                        ++ipv4RangesListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        if (revokeSecurityGroupEgressRequest.cidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.cidrIp()));
        }
        if (revokeSecurityGroupEgressRequest.fromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequest.fromPort()));
        }
        if (revokeSecurityGroupEgressRequest.ipProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.ipProtocol()));
        }
        if (revokeSecurityGroupEgressRequest.toPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)revokeSecurityGroupEgressRequest.toPort()));
        }
        if (revokeSecurityGroupEgressRequest.sourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.sourceSecurityGroupName()));
        }
        if (revokeSecurityGroupEgressRequest.sourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)revokeSecurityGroupEgressRequest.sourceSecurityGroupOwnerId()));
        }
        return request;
    }
}

