/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.InstanceCount;
import software.amazon.awssdk.services.ec2.model.PriceSchedule;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesListing;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.InstanceCountUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.PriceScheduleUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class ReservedInstancesListingUnmarshaller
implements Unmarshaller<ReservedInstancesListing, StaxUnmarshallerContext> {
    private static ReservedInstancesListingUnmarshaller INSTANCE;

    public ReservedInstancesListing unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ReservedInstancesListing.Builder reservedInstancesListing = ReservedInstancesListing.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("clientToken", targetDepth)) {
                    reservedInstancesListing.clientToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("createDate", targetDepth)) {
                    reservedInstancesListing.createDate(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceCounts", targetDepth)) {
                    reservedInstancesListing.instanceCounts(new ArrayList<InstanceCount>());
                    continue;
                }
                if (context.testExpression("instanceCounts/item", targetDepth)) {
                    reservedInstancesListing.instanceCounts(InstanceCountUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("priceSchedules", targetDepth)) {
                    reservedInstancesListing.priceSchedules(new ArrayList<PriceSchedule>());
                    continue;
                }
                if (context.testExpression("priceSchedules/item", targetDepth)) {
                    reservedInstancesListing.priceSchedules(PriceScheduleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("reservedInstancesId", targetDepth)) {
                    reservedInstancesListing.reservedInstancesId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("reservedInstancesListingId", targetDepth)) {
                    reservedInstancesListing.reservedInstancesListingId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("status", targetDepth)) {
                    reservedInstancesListing.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("statusMessage", targetDepth)) {
                    reservedInstancesListing.statusMessage(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    reservedInstancesListing.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    reservedInstancesListing.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("updateDate", targetDepth)) continue;
                reservedInstancesListing.updateDate(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ReservedInstancesListing)reservedInstancesListing.build();
    }

    public static ReservedInstancesListingUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ReservedInstancesListingUnmarshaller();
        }
        return INSTANCE;
    }
}

