/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceUnmarshaller;

public class ReservationUnmarshaller
implements Unmarshaller<Reservation, StaxUnmarshallerContext> {
    private static ReservationUnmarshaller INSTANCE;

    public Reservation unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Reservation.Builder reservation = Reservation.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("groupSet", targetDepth)) {
                    reservation.groups(new ArrayList<GroupIdentifier>());
                    continue;
                }
                if (context.testExpression("groupSet/item", targetDepth)) {
                    reservation.groups(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instancesSet", targetDepth)) {
                    reservation.instances(new ArrayList<Instance>());
                    continue;
                }
                if (context.testExpression("instancesSet/item", targetDepth)) {
                    reservation.instances(InstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ownerId", targetDepth)) {
                    reservation.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("requesterId", targetDepth)) {
                    reservation.requesterId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("reservationId", targetDepth)) {
                    reservation.reservationId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("groupName", targetDepth)) {
                    reservation.groupNames(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("groupName/GroupName", targetDepth)) continue;
                reservation.groupNames(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Reservation)reservation.build();
    }

    public static ReservationUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ReservationUnmarshaller();
        }
        return INSTANCE;
    }
}

