/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Purchase;

public class PurchaseUnmarshaller
implements Unmarshaller<Purchase, StaxUnmarshallerContext> {
    private static PurchaseUnmarshaller INSTANCE;

    public Purchase unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Purchase.Builder purchase = Purchase.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("currencyCode", targetDepth)) {
                    purchase.currencyCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("duration", targetDepth)) {
                    purchase.duration(SimpleTypeStaxUnmarshallers.IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostIdSet", targetDepth)) {
                    purchase.hostIdSet(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("hostIdSet/item", targetDepth)) {
                    purchase.hostIdSet(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostReservationId", targetDepth)) {
                    purchase.hostReservationId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hourlyPrice", targetDepth)) {
                    purchase.hourlyPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceFamily", targetDepth)) {
                    purchase.instanceFamily(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("paymentOption", targetDepth)) {
                    purchase.paymentOption(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("upfrontPrice", targetDepth)) continue;
                purchase.upfrontPrice(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Purchase)purchase.build();
    }

    public static PurchaseUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PurchaseUnmarshaller();
        }
        return INSTANCE;
    }
}

