/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest;
import software.amazon.awssdk.util.StringUtils;

public class PurchaseHostReservationRequestMarshaller
implements Marshaller<Request<PurchaseHostReservationRequest>, PurchaseHostReservationRequest> {
    public Request<PurchaseHostReservationRequest> marshall(PurchaseHostReservationRequest purchaseHostReservationRequest) {
        SdkInternalList purchaseHostReservationRequestHostIdSetList;
        if (purchaseHostReservationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)purchaseHostReservationRequest, "EC2Client");
        request.addParameter("Action", "PurchaseHostReservation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (purchaseHostReservationRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)purchaseHostReservationRequest.clientToken()));
        }
        if (purchaseHostReservationRequest.currencyCode() != null) {
            request.addParameter("CurrencyCode", StringUtils.fromString((String)purchaseHostReservationRequest.currencyCode()));
        }
        if (!(purchaseHostReservationRequestHostIdSetList = (SdkInternalList)purchaseHostReservationRequest.hostIdSet()).isEmpty() || !purchaseHostReservationRequestHostIdSetList.isAutoConstruct()) {
            int hostIdSetListIndex = 1;
            for (String purchaseHostReservationRequestHostIdSetListValue : purchaseHostReservationRequestHostIdSetList) {
                if (purchaseHostReservationRequestHostIdSetListValue != null) {
                    request.addParameter("HostIdSet." + hostIdSetListIndex, StringUtils.fromString((String)purchaseHostReservationRequestHostIdSetListValue));
                }
                ++hostIdSetListIndex;
            }
        }
        if (purchaseHostReservationRequest.limitPrice() != null) {
            request.addParameter("LimitPrice", StringUtils.fromString((String)purchaseHostReservationRequest.limitPrice()));
        }
        if (purchaseHostReservationRequest.offeringId() != null) {
            request.addParameter("OfferingId", StringUtils.fromString((String)purchaseHostReservationRequest.offeringId()));
        }
        return request;
    }
}

