/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.NetworkAcl;
import software.amazon.awssdk.services.ec2.model.NetworkAclAssociation;
import software.amazon.awssdk.services.ec2.model.NetworkAclEntry;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.NetworkAclAssociationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.NetworkAclEntryUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class NetworkAclUnmarshaller
implements Unmarshaller<NetworkAcl, StaxUnmarshallerContext> {
    private static NetworkAclUnmarshaller INSTANCE;

    public NetworkAcl unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        NetworkAcl.Builder networkAcl = NetworkAcl.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("associationSet", targetDepth)) {
                    networkAcl.associations(new ArrayList<NetworkAclAssociation>());
                    continue;
                }
                if (context.testExpression("associationSet/item", targetDepth)) {
                    networkAcl.associations(NetworkAclAssociationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("entrySet", targetDepth)) {
                    networkAcl.entries(new ArrayList<NetworkAclEntry>());
                    continue;
                }
                if (context.testExpression("entrySet/item", targetDepth)) {
                    networkAcl.entries(NetworkAclEntryUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("default", targetDepth)) {
                    networkAcl.isDefault(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("networkAclId", targetDepth)) {
                    networkAcl.networkAclId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    networkAcl.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    networkAcl.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpcId", targetDepth)) continue;
                networkAcl.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (NetworkAcl)networkAcl.build();
    }

    public static NetworkAclUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new NetworkAclUnmarshaller();
        }
        return INSTANCE;
    }
}

