/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ModifyVpcEndpointRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyVpcEndpointRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointRequest>, ModifyVpcEndpointRequest> {
    public Request<ModifyVpcEndpointRequest> marshall(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {
        SdkInternalList modifyVpcEndpointRequestRemoveRouteTableIdsList;
        if (modifyVpcEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcEndpointRequest, "EC2Client");
        request.addParameter("Action", "ModifyVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList modifyVpcEndpointRequestAddRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.addRouteTableIds();
        if (!modifyVpcEndpointRequestAddRouteTableIdsList.isEmpty() || !modifyVpcEndpointRequestAddRouteTableIdsList.isAutoConstruct()) {
            int addRouteTableIdsListIndex = 1;
            for (String modifyVpcEndpointRequestAddRouteTableIdsListValue : modifyVpcEndpointRequestAddRouteTableIdsList) {
                if (modifyVpcEndpointRequestAddRouteTableIdsListValue != null) {
                    request.addParameter("AddRouteTableId." + addRouteTableIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestAddRouteTableIdsListValue));
                }
                ++addRouteTableIdsListIndex;
            }
        }
        if (modifyVpcEndpointRequest.policyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString((String)modifyVpcEndpointRequest.policyDocument()));
        }
        if (!(modifyVpcEndpointRequestRemoveRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.removeRouteTableIds()).isEmpty() || !modifyVpcEndpointRequestRemoveRouteTableIdsList.isAutoConstruct()) {
            int removeRouteTableIdsListIndex = 1;
            for (String modifyVpcEndpointRequestRemoveRouteTableIdsListValue : modifyVpcEndpointRequestRemoveRouteTableIdsList) {
                if (modifyVpcEndpointRequestRemoveRouteTableIdsListValue != null) {
                    request.addParameter("RemoveRouteTableId." + removeRouteTableIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestRemoveRouteTableIdsListValue));
                }
                ++removeRouteTableIdsListIndex;
            }
        }
        if (modifyVpcEndpointRequest.resetPolicy() != null) {
            request.addParameter("ResetPolicy", StringUtils.fromBoolean((Boolean)modifyVpcEndpointRequest.resetPolicy()));
        }
        if (modifyVpcEndpointRequest.vpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString((String)modifyVpcEndpointRequest.vpcEndpointId()));
        }
        return request;
    }
}

