/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermission;
import software.amazon.awssdk.services.ec2.model.CreateVolumePermissionModifications;
import software.amazon.awssdk.services.ec2.model.ModifySnapshotAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        SdkInternalList modifySnapshotAttributeRequestUserIdsList;
        SdkInternalList modifySnapshotAttributeRequestGroupNamesList;
        CreateVolumePermissionModifications createVolumePermission;
        if (modifySnapshotAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySnapshotAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySnapshotAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifySnapshotAttributeRequest.attribute()));
        }
        if ((createVolumePermission = modifySnapshotAttributeRequest.createVolumePermission()) != null) {
            SdkInternalList createVolumePermissionModificationsRemoveList;
            SdkInternalList createVolumePermissionModificationsAddList = (SdkInternalList)createVolumePermission.add();
            if (!createVolumePermissionModificationsAddList.isEmpty() || !createVolumePermissionModificationsAddList.isAutoConstruct()) {
                int addListIndex = 1;
                for (Object createVolumePermissionModificationsAddListValue : createVolumePermissionModificationsAddList) {
                    if (((CreateVolumePermission)createVolumePermissionModificationsAddListValue).group() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)((CreateVolumePermission)createVolumePermissionModificationsAddListValue).group()));
                    }
                    if (((CreateVolumePermission)createVolumePermissionModificationsAddListValue).userId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)((CreateVolumePermission)createVolumePermissionModificationsAddListValue).userId()));
                    }
                    ++addListIndex;
                }
            }
            if (!(createVolumePermissionModificationsRemoveList = (SdkInternalList)createVolumePermission.remove()).isEmpty() || !createVolumePermissionModificationsRemoveList.isAutoConstruct()) {
                int removeListIndex = 1;
                for (CreateVolumePermission createVolumePermissionModificationsRemoveListValue : createVolumePermissionModificationsRemoveList) {
                    if (createVolumePermissionModificationsRemoveListValue.group() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)createVolumePermissionModificationsRemoveListValue.group()));
                    }
                    if (createVolumePermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)createVolumePermissionModificationsRemoveListValue.userId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (!(modifySnapshotAttributeRequestGroupNamesList = (SdkInternalList)modifySnapshotAttributeRequest.groupNames()).isEmpty() || !modifySnapshotAttributeRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String modifySnapshotAttributeRequestGroupNamesListValue : modifySnapshotAttributeRequestGroupNamesList) {
                if (modifySnapshotAttributeRequestGroupNamesListValue != null) {
                    request.addParameter("UserGroup." + groupNamesListIndex, StringUtils.fromString((String)modifySnapshotAttributeRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if (modifySnapshotAttributeRequest.operationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifySnapshotAttributeRequest.operationType()));
        }
        if (modifySnapshotAttributeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)modifySnapshotAttributeRequest.snapshotId()));
        }
        if (!(modifySnapshotAttributeRequestUserIdsList = (SdkInternalList)modifySnapshotAttributeRequest.userIds()).isEmpty() || !modifySnapshotAttributeRequestUserIdsList.isAutoConstruct()) {
            int userIdsListIndex = 1;
            for (String modifySnapshotAttributeRequestUserIdsListValue : modifySnapshotAttributeRequestUserIdsList) {
                if (modifySnapshotAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)modifySnapshotAttributeRequestUserIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        return request;
    }
}

