/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import software.amazon.awssdk.services.ec2.model.NetworkInterfaceAttachmentChanges;
import software.amazon.awssdk.util.StringUtils;

public class ModifyNetworkInterfaceAttributeRequestMarshaller
implements Marshaller<Request<ModifyNetworkInterfaceAttributeRequest>, ModifyNetworkInterfaceAttributeRequest> {
    public Request<ModifyNetworkInterfaceAttributeRequest> marshall(ModifyNetworkInterfaceAttributeRequest modifyNetworkInterfaceAttributeRequest) {
        SdkInternalList modifyNetworkInterfaceAttributeRequestGroupsList;
        if (modifyNetworkInterfaceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyNetworkInterfaceAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyNetworkInterfaceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        NetworkInterfaceAttachmentChanges attachment = modifyNetworkInterfaceAttributeRequest.attachment();
        if (attachment != null) {
            if (attachment.attachmentId() != null) {
                request.addParameter("Attachment.AttachmentId", StringUtils.fromString((String)attachment.attachmentId()));
            }
            if (attachment.deleteOnTermination() != null) {
                request.addParameter("Attachment.DeleteOnTermination", StringUtils.fromBoolean((Boolean)attachment.deleteOnTermination()));
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.description() != null) {
            request.addParameter("Description.Value", StringUtils.fromString((String)modifyNetworkInterfaceAttributeRequest.description()));
        }
        if (!(modifyNetworkInterfaceAttributeRequestGroupsList = (SdkInternalList)modifyNetworkInterfaceAttributeRequest.groups()).isEmpty() || !modifyNetworkInterfaceAttributeRequestGroupsList.isAutoConstruct()) {
            int groupsListIndex = 1;
            for (String modifyNetworkInterfaceAttributeRequestGroupsListValue : modifyNetworkInterfaceAttributeRequestGroupsList) {
                if (modifyNetworkInterfaceAttributeRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)modifyNetworkInterfaceAttributeRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (modifyNetworkInterfaceAttributeRequest.networkInterfaceId() != null) {
            request.addParameter("NetworkInterfaceId", StringUtils.fromString((String)modifyNetworkInterfaceAttributeRequest.networkInterfaceId()));
        }
        if (modifyNetworkInterfaceAttributeRequest.sourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringUtils.fromBoolean((Boolean)modifyNetworkInterfaceAttributeRequest.sourceDestCheck()));
        }
        return request;
    }
}

