/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.LaunchPermission;
import software.amazon.awssdk.services.ec2.model.LaunchPermissionModifications;
import software.amazon.awssdk.services.ec2.model.ModifyImageAttributeRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {
    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        SdkInternalList modifyImageAttributeRequestUserIdsList;
        SdkInternalList modifyImageAttributeRequestUserGroupsList;
        SdkInternalList modifyImageAttributeRequestProductCodesList;
        LaunchPermissionModifications launchPermission;
        if (modifyImageAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyImageAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyImageAttributeRequest.attribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifyImageAttributeRequest.attribute()));
        }
        if (modifyImageAttributeRequest.description() != null) {
            request.addParameter("Description.Value", StringUtils.fromString((String)modifyImageAttributeRequest.description()));
        }
        if (modifyImageAttributeRequest.imageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)modifyImageAttributeRequest.imageId()));
        }
        if ((launchPermission = modifyImageAttributeRequest.launchPermission()) != null) {
            SdkInternalList launchPermissionModificationsRemoveList;
            SdkInternalList launchPermissionModificationsAddList = (SdkInternalList)launchPermission.add();
            if (!launchPermissionModificationsAddList.isEmpty() || !launchPermissionModificationsAddList.isAutoConstruct()) {
                int addListIndex = 1;
                for (Object launchPermissionModificationsAddListValue : launchPermissionModificationsAddList) {
                    if (((LaunchPermission)launchPermissionModificationsAddListValue).group() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)((LaunchPermission)launchPermissionModificationsAddListValue).group()));
                    }
                    if (((LaunchPermission)launchPermissionModificationsAddListValue).userId() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)((LaunchPermission)launchPermissionModificationsAddListValue).userId()));
                    }
                    ++addListIndex;
                }
            }
            if (!(launchPermissionModificationsRemoveList = (SdkInternalList)launchPermission.remove()).isEmpty() || !launchPermissionModificationsRemoveList.isAutoConstruct()) {
                int removeListIndex = 1;
                for (LaunchPermission launchPermissionModificationsRemoveListValue : launchPermissionModificationsRemoveList) {
                    if (launchPermissionModificationsRemoveListValue.group() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)launchPermissionModificationsRemoveListValue.group()));
                    }
                    if (launchPermissionModificationsRemoveListValue.userId() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)launchPermissionModificationsRemoveListValue.userId()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (modifyImageAttributeRequest.operationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifyImageAttributeRequest.operationType()));
        }
        if (!(modifyImageAttributeRequestProductCodesList = (SdkInternalList)modifyImageAttributeRequest.productCodes()).isEmpty() || !modifyImageAttributeRequestProductCodesList.isAutoConstruct()) {
            int productCodesListIndex = 1;
            for (Object modifyImageAttributeRequestProductCodesListValue : modifyImageAttributeRequestProductCodesList) {
                if (modifyImageAttributeRequestProductCodesListValue != null) {
                    request.addParameter("ProductCode." + productCodesListIndex, StringUtils.fromString((String)modifyImageAttributeRequestProductCodesListValue));
                }
                ++productCodesListIndex;
            }
        }
        if (!(modifyImageAttributeRequestUserGroupsList = (SdkInternalList)modifyImageAttributeRequest.userGroups()).isEmpty() || !modifyImageAttributeRequestUserGroupsList.isAutoConstruct()) {
            int userGroupsListIndex = 1;
            for (String modifyImageAttributeRequestUserGroupsListValue : modifyImageAttributeRequestUserGroupsList) {
                if (modifyImageAttributeRequestUserGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString((String)modifyImageAttributeRequestUserGroupsListValue));
                }
                ++userGroupsListIndex;
            }
        }
        if (!(modifyImageAttributeRequestUserIdsList = (SdkInternalList)modifyImageAttributeRequest.userIds()).isEmpty() || !modifyImageAttributeRequestUserIdsList.isAutoConstruct()) {
            int userIdsListIndex = 1;
            for (String modifyImageAttributeRequestUserIdsListValue : modifyImageAttributeRequestUserIdsList) {
                if (modifyImageAttributeRequestUserIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)modifyImageAttributeRequestUserIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (modifyImageAttributeRequest.value() != null) {
            request.addParameter("Value", StringUtils.fromString((String)modifyImageAttributeRequest.value()));
        }
        return request;
    }
}

