/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.InstanceStateChange;
import software.amazon.awssdk.services.ec2.transform.InstanceStateUnmarshaller;

public class InstanceStateChangeUnmarshaller
implements Unmarshaller<InstanceStateChange, StaxUnmarshallerContext> {
    private static InstanceStateChangeUnmarshaller INSTANCE;

    public InstanceStateChange unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        InstanceStateChange.Builder instanceStateChange = InstanceStateChange.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("currentState", targetDepth)) {
                    instanceStateChange.currentState(InstanceStateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceId", targetDepth)) {
                    instanceStateChange.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("previousState", targetDepth)) continue;
                instanceStateChange.previousState(InstanceStateUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (InstanceStateChange)instanceStateChange.build();
    }

    public static InstanceStateChangeUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InstanceStateChangeUnmarshaller();
        }
        return INSTANCE;
    }
}

