/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.ProductCode;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.BlockDeviceMappingUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ProductCodeUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.StateReasonUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class ImageUnmarshaller
implements Unmarshaller<Image, StaxUnmarshallerContext> {
    private static ImageUnmarshaller INSTANCE;

    public Image unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Image.Builder image = Image.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("architecture", targetDepth)) {
                    image.architecture(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("creationDate", targetDepth)) {
                    image.creationDate(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageId", targetDepth)) {
                    image.imageId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageLocation", targetDepth)) {
                    image.imageLocation(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageType", targetDepth)) {
                    image.imageType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("kernelId", targetDepth)) {
                    image.kernelId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageOwnerId", targetDepth)) {
                    image.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("platform", targetDepth)) {
                    image.platform(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("productCodes", targetDepth)) {
                    image.productCodes(new ArrayList<ProductCode>());
                    continue;
                }
                if (context.testExpression("productCodes/item", targetDepth)) {
                    image.productCodes(ProductCodeUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ramdiskId", targetDepth)) {
                    image.ramdiskId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageState", targetDepth)) {
                    image.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("blockDeviceMapping", targetDepth)) {
                    image.blockDeviceMappings(new ArrayList<BlockDeviceMapping>());
                    continue;
                }
                if (context.testExpression("blockDeviceMapping/item", targetDepth)) {
                    image.blockDeviceMappings(BlockDeviceMappingUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("description", targetDepth)) {
                    image.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("enaSupport", targetDepth)) {
                    image.enaSupport(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hypervisor", targetDepth)) {
                    image.hypervisor(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("imageOwnerAlias", targetDepth)) {
                    image.imageOwnerAlias(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("name", targetDepth)) {
                    image.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("rootDeviceName", targetDepth)) {
                    image.rootDeviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("rootDeviceType", targetDepth)) {
                    image.rootDeviceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("sriovNetSupport", targetDepth)) {
                    image.sriovNetSupport(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("stateReason", targetDepth)) {
                    image.stateReason(StateReasonUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    image.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    image.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("virtualizationType", targetDepth)) {
                    image.virtualizationType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("isPublic", targetDepth)) continue;
                image.publicLaunchPermissions(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Image)image.build();
    }

    public static ImageUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ImageUnmarshaller();
        }
        return INSTANCE;
    }
}

