/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.Host;
import software.amazon.awssdk.services.ec2.model.HostInstance;
import software.amazon.awssdk.services.ec2.transform.AvailableCapacityUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.HostInstanceUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.HostPropertiesUnmarshaller;

public class HostUnmarshaller
implements Unmarshaller<Host, StaxUnmarshallerContext> {
    private static HostUnmarshaller INSTANCE;

    public Host unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        Host.Builder host = Host.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("autoPlacement", targetDepth)) {
                    host.autoPlacement(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availabilityZone", targetDepth)) {
                    host.availabilityZone(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("availableCapacity", targetDepth)) {
                    host.availableCapacity(AvailableCapacityUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("clientToken", targetDepth)) {
                    host.clientToken(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostId", targetDepth)) {
                    host.hostId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostProperties", targetDepth)) {
                    host.hostProperties(HostPropertiesUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("hostReservationId", targetDepth)) {
                    host.hostReservationId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instances", targetDepth)) {
                    host.instances(new ArrayList<HostInstance>());
                    continue;
                }
                if (context.testExpression("instances/item", targetDepth)) {
                    host.instances(HostInstanceUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("state", targetDepth)) continue;
                host.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (Host)host.build();
    }

    public static HostUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HostUnmarshaller();
        }
        return INSTANCE;
    }
}

