/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDevice;

public class EbsInstanceBlockDeviceUnmarshaller
implements Unmarshaller<EbsInstanceBlockDevice, StaxUnmarshallerContext> {
    private static EbsInstanceBlockDeviceUnmarshaller INSTANCE;

    public EbsInstanceBlockDevice unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EbsInstanceBlockDevice.Builder ebsInstanceBlockDevice = EbsInstanceBlockDevice.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("attachTime", targetDepth)) {
                    ebsInstanceBlockDevice.attachTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("deleteOnTermination", targetDepth)) {
                    ebsInstanceBlockDevice.deleteOnTermination(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("status", targetDepth)) {
                    ebsInstanceBlockDevice.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("volumeId", targetDepth)) continue;
                ebsInstanceBlockDevice.volumeId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EbsInstanceBlockDevice)ebsInstanceBlockDevice.build();
    }

    public static EbsInstanceBlockDeviceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EbsInstanceBlockDeviceUnmarshaller();
        }
        return INSTANCE;
    }
}

