/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.DhcpConfiguration;
import software.amazon.awssdk.services.ec2.model.DhcpOptions;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.DhcpConfigurationUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class DhcpOptionsUnmarshaller
implements Unmarshaller<DhcpOptions, StaxUnmarshallerContext> {
    private static DhcpOptionsUnmarshaller INSTANCE;

    public DhcpOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DhcpOptions.Builder dhcpOptions = DhcpOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("dhcpConfigurationSet", targetDepth)) {
                    dhcpOptions.dhcpConfigurations(new ArrayList<DhcpConfiguration>());
                    continue;
                }
                if (context.testExpression("dhcpConfigurationSet/item", targetDepth)) {
                    dhcpOptions.dhcpConfigurations(DhcpConfigurationUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("dhcpOptionsId", targetDepth)) {
                    dhcpOptions.dhcpOptionsId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    dhcpOptions.tags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("tagSet/item", targetDepth)) continue;
                dhcpOptions.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DhcpOptions)dhcpOptions.build();
    }

    public static DhcpOptionsUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DhcpOptionsUnmarshaller();
        }
        return INSTANCE;
    }
}

