/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVpcPeeringConnectionsRequestMarshaller
implements Marshaller<Request<DescribeVpcPeeringConnectionsRequest>, DescribeVpcPeeringConnectionsRequest> {
    public Request<DescribeVpcPeeringConnectionsRequest> marshall(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        SdkInternalList describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList;
        if (describeVpcPeeringConnectionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcPeeringConnectionsRequest, "EC2Client");
        request.addParameter("Action", "DescribeVpcPeeringConnections");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpcPeeringConnectionsRequestFiltersList = (SdkInternalList)describeVpcPeeringConnectionsRequest.filters();
        if (!describeVpcPeeringConnectionsRequestFiltersList.isEmpty() || !describeVpcPeeringConnectionsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpcPeeringConnectionsRequestFiltersListValue : describeVpcPeeringConnectionsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpcPeeringConnectionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpcPeeringConnectionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpcPeeringConnectionsRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList = (SdkInternalList)describeVpcPeeringConnectionsRequest.vpcPeeringConnectionIds()).isEmpty() || !describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList.isAutoConstruct()) {
            int vpcPeeringConnectionIdsListIndex = 1;
            for (String describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsListValue : describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsList) {
                if (describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsListValue != null) {
                    request.addParameter("VpcPeeringConnectionId." + vpcPeeringConnectionIdsListIndex, StringUtils.fromString((String)describeVpcPeeringConnectionsRequestVpcPeeringConnectionIdsListValue));
                }
                ++vpcPeeringConnectionIdsListIndex;
            }
        }
        return request;
    }
}

