/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeVolumesRequestMarshaller
implements Marshaller<Request<DescribeVolumesRequest>, DescribeVolumesRequest> {
    public Request<DescribeVolumesRequest> marshall(DescribeVolumesRequest describeVolumesRequest) {
        SdkInternalList describeVolumesRequestVolumeIdsList;
        if (describeVolumesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVolumesRequest, "EC2Client");
        request.addParameter("Action", "DescribeVolumes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVolumesRequestFiltersList = (SdkInternalList)describeVolumesRequest.filters();
        if (!describeVolumesRequestFiltersList.isEmpty() || !describeVolumesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVolumesRequestFiltersListValue : describeVolumesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVolumesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVolumesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVolumesRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeVolumesRequestVolumeIdsList = (SdkInternalList)describeVolumesRequest.volumeIds()).isEmpty() || !describeVolumesRequestVolumeIdsList.isAutoConstruct()) {
            int volumeIdsListIndex = 1;
            for (String describeVolumesRequestVolumeIdsListValue : describeVolumesRequestVolumeIdsList) {
                if (describeVolumesRequestVolumeIdsListValue != null) {
                    request.addParameter("VolumeId." + volumeIdsListIndex, StringUtils.fromString((String)describeVolumesRequestVolumeIdsListValue));
                }
                ++volumeIdsListIndex;
            }
        }
        if (describeVolumesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVolumesRequest.maxResults()));
        }
        if (describeVolumesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVolumesRequest.nextToken()));
        }
        return request;
    }
}

