/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSpotPriceHistoryRequestMarshaller
implements Marshaller<Request<DescribeSpotPriceHistoryRequest>, DescribeSpotPriceHistoryRequest> {
    public Request<DescribeSpotPriceHistoryRequest> marshall(DescribeSpotPriceHistoryRequest describeSpotPriceHistoryRequest) {
        SdkInternalList describeSpotPriceHistoryRequestProductDescriptionsList;
        SdkInternalList describeSpotPriceHistoryRequestInstanceTypesList;
        if (describeSpotPriceHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSpotPriceHistoryRequest, "EC2Client");
        request.addParameter("Action", "DescribeSpotPriceHistory");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeSpotPriceHistoryRequestFiltersList = (SdkInternalList)describeSpotPriceHistoryRequest.filters();
        if (!describeSpotPriceHistoryRequestFiltersList.isEmpty() || !describeSpotPriceHistoryRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describeSpotPriceHistoryRequestFiltersListValue : describeSpotPriceHistoryRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describeSpotPriceHistoryRequestFiltersListValue).name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)((Filter)describeSpotPriceHistoryRequestFiltersListValue).name()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describeSpotPriceHistoryRequestFiltersListValue).values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeSpotPriceHistoryRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)describeSpotPriceHistoryRequest.availabilityZone()));
        }
        if (describeSpotPriceHistoryRequest.endTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate((Date)describeSpotPriceHistoryRequest.endTime()));
        }
        if (!(describeSpotPriceHistoryRequestInstanceTypesList = (SdkInternalList)describeSpotPriceHistoryRequest.instanceTypes()).isEmpty() || !describeSpotPriceHistoryRequestInstanceTypesList.isAutoConstruct()) {
            int instanceTypesListIndex = 1;
            for (String describeSpotPriceHistoryRequestInstanceTypesListValue : describeSpotPriceHistoryRequestInstanceTypesList) {
                if (describeSpotPriceHistoryRequestInstanceTypesListValue != null) {
                    request.addParameter("InstanceType." + instanceTypesListIndex, StringUtils.fromString((String)describeSpotPriceHistoryRequestInstanceTypesListValue));
                }
                ++instanceTypesListIndex;
            }
        }
        if (describeSpotPriceHistoryRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSpotPriceHistoryRequest.maxResults()));
        }
        if (describeSpotPriceHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSpotPriceHistoryRequest.nextToken()));
        }
        if (!(describeSpotPriceHistoryRequestProductDescriptionsList = (SdkInternalList)describeSpotPriceHistoryRequest.productDescriptions()).isEmpty() || !describeSpotPriceHistoryRequestProductDescriptionsList.isAutoConstruct()) {
            int productDescriptionsListIndex = 1;
            for (String describeSpotPriceHistoryRequestProductDescriptionsListValue : describeSpotPriceHistoryRequestProductDescriptionsList) {
                if (describeSpotPriceHistoryRequestProductDescriptionsListValue != null) {
                    request.addParameter("ProductDescription." + productDescriptionsListIndex, StringUtils.fromString((String)describeSpotPriceHistoryRequestProductDescriptionsListValue));
                }
                ++productDescriptionsListIndex;
            }
        }
        if (describeSpotPriceHistoryRequest.startTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate((Date)describeSpotPriceHistoryRequest.startTime()));
        }
        return request;
    }
}

