/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeSpotFleetRequestsRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSpotFleetRequestsRequestMarshaller
implements Marshaller<Request<DescribeSpotFleetRequestsRequest>, DescribeSpotFleetRequestsRequest> {
    public Request<DescribeSpotFleetRequestsRequest> marshall(DescribeSpotFleetRequestsRequest describeSpotFleetRequestsRequest) {
        SdkInternalList describeSpotFleetRequestsRequestSpotFleetRequestIdsList;
        if (describeSpotFleetRequestsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSpotFleetRequestsRequest, "EC2Client");
        request.addParameter("Action", "DescribeSpotFleetRequests");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSpotFleetRequestsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSpotFleetRequestsRequest.maxResults()));
        }
        if (describeSpotFleetRequestsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSpotFleetRequestsRequest.nextToken()));
        }
        if (!(describeSpotFleetRequestsRequestSpotFleetRequestIdsList = (SdkInternalList)describeSpotFleetRequestsRequest.spotFleetRequestIds()).isEmpty() || !describeSpotFleetRequestsRequestSpotFleetRequestIdsList.isAutoConstruct()) {
            int spotFleetRequestIdsListIndex = 1;
            for (String describeSpotFleetRequestsRequestSpotFleetRequestIdsListValue : describeSpotFleetRequestsRequestSpotFleetRequestIdsList) {
                if (describeSpotFleetRequestsRequestSpotFleetRequestIdsListValue != null) {
                    request.addParameter("SpotFleetRequestId." + spotFleetRequestIdsListIndex, StringUtils.fromString((String)describeSpotFleetRequestsRequestSpotFleetRequestIdsListValue));
                }
                ++spotFleetRequestIdsListIndex;
            }
        }
        return request;
    }
}

