/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        SdkInternalList describeSnapshotsRequestSnapshotIdsList;
        SdkInternalList describeSnapshotsRequestRestorableByUserIdsList;
        SdkInternalList describeSnapshotsRequestOwnerIdsList;
        if (describeSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSnapshotsRequest, "EC2Client");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeSnapshotsRequestFiltersList = (SdkInternalList)describeSnapshotsRequest.filters();
        if (!describeSnapshotsRequestFiltersList.isEmpty() || !describeSnapshotsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describeSnapshotsRequestFiltersListValue : describeSnapshotsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describeSnapshotsRequestFiltersListValue).name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)((Filter)describeSnapshotsRequestFiltersListValue).name()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describeSnapshotsRequestFiltersListValue).values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeSnapshotsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSnapshotsRequest.maxResults()));
        }
        if (describeSnapshotsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSnapshotsRequest.nextToken()));
        }
        if (!(describeSnapshotsRequestOwnerIdsList = (SdkInternalList)describeSnapshotsRequest.ownerIds()).isEmpty() || !describeSnapshotsRequestOwnerIdsList.isAutoConstruct()) {
            int ownerIdsListIndex = 1;
            for (Object describeSnapshotsRequestOwnerIdsListValue : describeSnapshotsRequestOwnerIdsList) {
                if (describeSnapshotsRequestOwnerIdsListValue != null) {
                    request.addParameter("Owner." + ownerIdsListIndex, StringUtils.fromString((String)describeSnapshotsRequestOwnerIdsListValue));
                }
                ++ownerIdsListIndex;
            }
        }
        if (!(describeSnapshotsRequestRestorableByUserIdsList = (SdkInternalList)describeSnapshotsRequest.restorableByUserIds()).isEmpty() || !describeSnapshotsRequestRestorableByUserIdsList.isAutoConstruct()) {
            int restorableByUserIdsListIndex = 1;
            for (String describeSnapshotsRequestRestorableByUserIdsListValue : describeSnapshotsRequestRestorableByUserIdsList) {
                if (describeSnapshotsRequestRestorableByUserIdsListValue != null) {
                    request.addParameter("RestorableBy." + restorableByUserIdsListIndex, StringUtils.fromString((String)describeSnapshotsRequestRestorableByUserIdsListValue));
                }
                ++restorableByUserIdsListIndex;
            }
        }
        if (!(describeSnapshotsRequestSnapshotIdsList = (SdkInternalList)describeSnapshotsRequest.snapshotIds()).isEmpty() || !describeSnapshotsRequestSnapshotIdsList.isAutoConstruct()) {
            int snapshotIdsListIndex = 1;
            for (String describeSnapshotsRequestSnapshotIdsListValue : describeSnapshotsRequestSnapshotIdsList) {
                if (describeSnapshotsRequestSnapshotIdsListValue != null) {
                    request.addParameter("SnapshotId." + snapshotIdsListIndex, StringUtils.fromString((String)describeSnapshotsRequestSnapshotIdsListValue));
                }
                ++snapshotIdsListIndex;
            }
        }
        return request;
    }
}

