/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeSecurityGroupsRequest>, DescribeSecurityGroupsRequest> {
    public Request<DescribeSecurityGroupsRequest> marshall(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        SdkInternalList describeSecurityGroupsRequestGroupNamesList;
        SdkInternalList describeSecurityGroupsRequestGroupIdsList;
        if (describeSecurityGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSecurityGroupsRequest, "EC2Client");
        request.addParameter("Action", "DescribeSecurityGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeSecurityGroupsRequestFiltersList = (SdkInternalList)describeSecurityGroupsRequest.filters();
        if (!describeSecurityGroupsRequestFiltersList.isEmpty() || !describeSecurityGroupsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describeSecurityGroupsRequestFiltersListValue : describeSecurityGroupsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describeSecurityGroupsRequestFiltersListValue).name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)((Filter)describeSecurityGroupsRequestFiltersListValue).name()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describeSecurityGroupsRequestFiltersListValue).values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeSecurityGroupsRequestGroupIdsList = (SdkInternalList)describeSecurityGroupsRequest.groupIds()).isEmpty() || !describeSecurityGroupsRequestGroupIdsList.isAutoConstruct()) {
            int groupIdsListIndex = 1;
            for (String describeSecurityGroupsRequestGroupIdsListValue : describeSecurityGroupsRequestGroupIdsList) {
                if (describeSecurityGroupsRequestGroupIdsListValue != null) {
                    request.addParameter("GroupId." + groupIdsListIndex, StringUtils.fromString((String)describeSecurityGroupsRequestGroupIdsListValue));
                }
                ++groupIdsListIndex;
            }
        }
        if (!(describeSecurityGroupsRequestGroupNamesList = (SdkInternalList)describeSecurityGroupsRequest.groupNames()).isEmpty() || !describeSecurityGroupsRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String describeSecurityGroupsRequestGroupNamesListValue : describeSecurityGroupsRequestGroupNamesList) {
                if (describeSecurityGroupsRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringUtils.fromString((String)describeSecurityGroupsRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        return request;
    }
}

