/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.Date;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeScheduledInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.SlotStartTimeRangeRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeScheduledInstancesRequestMarshaller
implements Marshaller<Request<DescribeScheduledInstancesRequest>, DescribeScheduledInstancesRequest> {
    public Request<DescribeScheduledInstancesRequest> marshall(DescribeScheduledInstancesRequest describeScheduledInstancesRequest) {
        SlotStartTimeRangeRequest slotStartTimeRange;
        SdkInternalList describeScheduledInstancesRequestScheduledInstanceIdsList;
        if (describeScheduledInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeScheduledInstancesRequest, "EC2Client");
        request.addParameter("Action", "DescribeScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeScheduledInstancesRequestFiltersList = (SdkInternalList)describeScheduledInstancesRequest.filters();
        if (!describeScheduledInstancesRequestFiltersList.isEmpty() || !describeScheduledInstancesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeScheduledInstancesRequestFiltersListValue : describeScheduledInstancesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeScheduledInstancesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeScheduledInstancesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeScheduledInstancesRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeScheduledInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeScheduledInstancesRequest.maxResults()));
        }
        if (describeScheduledInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeScheduledInstancesRequest.nextToken()));
        }
        if (!(describeScheduledInstancesRequestScheduledInstanceIdsList = (SdkInternalList)describeScheduledInstancesRequest.scheduledInstanceIds()).isEmpty() || !describeScheduledInstancesRequestScheduledInstanceIdsList.isAutoConstruct()) {
            int scheduledInstanceIdsListIndex = 1;
            for (String describeScheduledInstancesRequestScheduledInstanceIdsListValue : describeScheduledInstancesRequestScheduledInstanceIdsList) {
                if (describeScheduledInstancesRequestScheduledInstanceIdsListValue != null) {
                    request.addParameter("ScheduledInstanceId." + scheduledInstanceIdsListIndex, StringUtils.fromString((String)describeScheduledInstancesRequestScheduledInstanceIdsListValue));
                }
                ++scheduledInstanceIdsListIndex;
            }
        }
        if ((slotStartTimeRange = describeScheduledInstancesRequest.slotStartTimeRange()) != null) {
            if (slotStartTimeRange.earliestTime() != null) {
                request.addParameter("SlotStartTimeRange.EarliestTime", StringUtils.fromDate((Date)slotStartTimeRange.earliestTime()));
            }
            if (slotStartTimeRange.latestTime() != null) {
                request.addParameter("SlotStartTimeRange.LatestTime", StringUtils.fromDate((Date)slotStartTimeRange.latestTime()));
            }
        }
        return request;
    }
}

