/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeRouteTablesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeRouteTablesRequestMarshaller
implements Marshaller<Request<DescribeRouteTablesRequest>, DescribeRouteTablesRequest> {
    public Request<DescribeRouteTablesRequest> marshall(DescribeRouteTablesRequest describeRouteTablesRequest) {
        SdkInternalList describeRouteTablesRequestRouteTableIdsList;
        if (describeRouteTablesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeRouteTablesRequest, "EC2Client");
        request.addParameter("Action", "DescribeRouteTables");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeRouteTablesRequestFiltersList = (SdkInternalList)describeRouteTablesRequest.filters();
        if (!describeRouteTablesRequestFiltersList.isEmpty() || !describeRouteTablesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeRouteTablesRequestFiltersListValue : describeRouteTablesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeRouteTablesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeRouteTablesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeRouteTablesRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeRouteTablesRequestRouteTableIdsList = (SdkInternalList)describeRouteTablesRequest.routeTableIds()).isEmpty() || !describeRouteTablesRequestRouteTableIdsList.isAutoConstruct()) {
            int routeTableIdsListIndex = 1;
            for (String describeRouteTablesRequestRouteTableIdsListValue : describeRouteTablesRequestRouteTableIdsList) {
                if (describeRouteTablesRequestRouteTableIdsListValue != null) {
                    request.addParameter("RouteTableId." + routeTableIdsListIndex, StringUtils.fromString((String)describeRouteTablesRequestRouteTableIdsListValue));
                }
                ++routeTableIdsListIndex;
            }
        }
        return request;
    }
}

