/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeReservedInstancesOfferingsRequestMarshaller
implements Marshaller<Request<DescribeReservedInstancesOfferingsRequest>, DescribeReservedInstancesOfferingsRequest> {
    public Request<DescribeReservedInstancesOfferingsRequest> marshall(DescribeReservedInstancesOfferingsRequest describeReservedInstancesOfferingsRequest) {
        SdkInternalList describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList;
        SdkInternalList describeReservedInstancesOfferingsRequestFiltersList;
        if (describeReservedInstancesOfferingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedInstancesOfferingsRequest, "EC2Client");
        request.addParameter("Action", "DescribeReservedInstancesOfferings");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedInstancesOfferingsRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.availabilityZone()));
        }
        if (!(describeReservedInstancesOfferingsRequestFiltersList = (SdkInternalList)describeReservedInstancesOfferingsRequest.filters()).isEmpty() || !describeReservedInstancesOfferingsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeReservedInstancesOfferingsRequestFiltersListValue : describeReservedInstancesOfferingsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeReservedInstancesOfferingsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeReservedInstancesOfferingsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeReservedInstancesOfferingsRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeReservedInstancesOfferingsRequest.includeMarketplace() != null) {
            request.addParameter("IncludeMarketplace", StringUtils.fromBoolean((Boolean)describeReservedInstancesOfferingsRequest.includeMarketplace()));
        }
        if (describeReservedInstancesOfferingsRequest.instanceType() != null) {
            request.addParameter("InstanceType", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.instanceType()));
        }
        if (describeReservedInstancesOfferingsRequest.maxDuration() != null) {
            request.addParameter("MaxDuration", StringUtils.fromLong((Long)describeReservedInstancesOfferingsRequest.maxDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.maxInstanceCount() != null) {
            request.addParameter("MaxInstanceCount", StringUtils.fromInteger((Integer)describeReservedInstancesOfferingsRequest.maxInstanceCount()));
        }
        if (describeReservedInstancesOfferingsRequest.minDuration() != null) {
            request.addParameter("MinDuration", StringUtils.fromLong((Long)describeReservedInstancesOfferingsRequest.minDuration()));
        }
        if (describeReservedInstancesOfferingsRequest.offeringClass() != null) {
            request.addParameter("OfferingClass", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.offeringClass()));
        }
        if (describeReservedInstancesOfferingsRequest.productDescription() != null) {
            request.addParameter("ProductDescription", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.productDescription()));
        }
        if (!(describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList = (SdkInternalList)describeReservedInstancesOfferingsRequest.reservedInstancesOfferingIds()).isEmpty() || !describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList.isAutoConstruct()) {
            int reservedInstancesOfferingIdsListIndex = 1;
            for (String describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue : describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsList) {
                if (describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue != null) {
                    request.addParameter("ReservedInstancesOfferingId." + reservedInstancesOfferingIdsListIndex, StringUtils.fromString((String)describeReservedInstancesOfferingsRequestReservedInstancesOfferingIdsListValue));
                }
                ++reservedInstancesOfferingIdsListIndex;
            }
        }
        if (describeReservedInstancesOfferingsRequest.instanceTenancy() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.instanceTenancy()));
        }
        if (describeReservedInstancesOfferingsRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeReservedInstancesOfferingsRequest.maxResults()));
        }
        if (describeReservedInstancesOfferingsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.nextToken()));
        }
        if (describeReservedInstancesOfferingsRequest.offeringType() != null) {
            request.addParameter("OfferingType", StringUtils.fromString((String)describeReservedInstancesOfferingsRequest.offeringType()));
        }
        return request;
    }
}

