/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeMovingAddressesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeMovingAddressesRequestMarshaller
implements Marshaller<Request<DescribeMovingAddressesRequest>, DescribeMovingAddressesRequest> {
    public Request<DescribeMovingAddressesRequest> marshall(DescribeMovingAddressesRequest describeMovingAddressesRequest) {
        SdkInternalList describeMovingAddressesRequestPublicIpsList;
        if (describeMovingAddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeMovingAddressesRequest, "EC2Client");
        request.addParameter("Action", "DescribeMovingAddresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeMovingAddressesRequestFiltersList = (SdkInternalList)describeMovingAddressesRequest.filters();
        if (!describeMovingAddressesRequestFiltersList.isEmpty() || !describeMovingAddressesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeMovingAddressesRequestFiltersListValue : describeMovingAddressesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeMovingAddressesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeMovingAddressesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeMovingAddressesRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeMovingAddressesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeMovingAddressesRequest.maxResults()));
        }
        if (describeMovingAddressesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeMovingAddressesRequest.nextToken()));
        }
        if (!(describeMovingAddressesRequestPublicIpsList = (SdkInternalList)describeMovingAddressesRequest.publicIps()).isEmpty() || !describeMovingAddressesRequestPublicIpsList.isAutoConstruct()) {
            int publicIpsListIndex = 1;
            for (String describeMovingAddressesRequestPublicIpsListValue : describeMovingAddressesRequestPublicIpsList) {
                if (describeMovingAddressesRequestPublicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex, StringUtils.fromString((String)describeMovingAddressesRequestPublicIpsListValue));
                }
                ++publicIpsListIndex;
            }
        }
        return request;
    }
}

