/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeImportSnapshotTasksRequestMarshaller
implements Marshaller<Request<DescribeImportSnapshotTasksRequest>, DescribeImportSnapshotTasksRequest> {
    public Request<DescribeImportSnapshotTasksRequest> marshall(DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {
        SdkInternalList describeImportSnapshotTasksRequestImportTaskIdsList;
        if (describeImportSnapshotTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeImportSnapshotTasksRequest, "EC2Client");
        request.addParameter("Action", "DescribeImportSnapshotTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeImportSnapshotTasksRequestFiltersList = (SdkInternalList)describeImportSnapshotTasksRequest.filters();
        if (!describeImportSnapshotTasksRequestFiltersList.isEmpty() || !describeImportSnapshotTasksRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeImportSnapshotTasksRequestFiltersListValue : describeImportSnapshotTasksRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeImportSnapshotTasksRequestFiltersListValue.name() != null) {
                    request.addParameter("Filters." + filtersListIndex + ".Name", StringUtils.fromString((String)describeImportSnapshotTasksRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeImportSnapshotTasksRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filters." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeImportSnapshotTasksRequestImportTaskIdsList = (SdkInternalList)describeImportSnapshotTasksRequest.importTaskIds()).isEmpty() || !describeImportSnapshotTasksRequestImportTaskIdsList.isAutoConstruct()) {
            int importTaskIdsListIndex = 1;
            for (String describeImportSnapshotTasksRequestImportTaskIdsListValue : describeImportSnapshotTasksRequestImportTaskIdsList) {
                if (describeImportSnapshotTasksRequestImportTaskIdsListValue != null) {
                    request.addParameter("ImportTaskId." + importTaskIdsListIndex, StringUtils.fromString((String)describeImportSnapshotTasksRequestImportTaskIdsListValue));
                }
                ++importTaskIdsListIndex;
            }
        }
        if (describeImportSnapshotTasksRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeImportSnapshotTasksRequest.maxResults()));
        }
        if (describeImportSnapshotTasksRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeImportSnapshotTasksRequest.nextToken()));
        }
        return request;
    }
}

