/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeImagesRequestMarshaller
implements Marshaller<Request<DescribeImagesRequest>, DescribeImagesRequest> {
    public Request<DescribeImagesRequest> marshall(DescribeImagesRequest describeImagesRequest) {
        SdkInternalList describeImagesRequestOwnersList;
        SdkInternalList describeImagesRequestImageIdsList;
        SdkInternalList describeImagesRequestFiltersList;
        if (describeImagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeImagesRequest, "EC2Client");
        request.addParameter("Action", "DescribeImages");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeImagesRequestExecutableUsersList = (SdkInternalList)describeImagesRequest.executableUsers();
        if (!describeImagesRequestExecutableUsersList.isEmpty() || !describeImagesRequestExecutableUsersList.isAutoConstruct()) {
            int executableUsersListIndex = 1;
            for (Object describeImagesRequestExecutableUsersListValue : describeImagesRequestExecutableUsersList) {
                if (describeImagesRequestExecutableUsersListValue != null) {
                    request.addParameter("ExecutableBy." + executableUsersListIndex, StringUtils.fromString((String)describeImagesRequestExecutableUsersListValue));
                }
                ++executableUsersListIndex;
            }
        }
        if (!(describeImagesRequestFiltersList = (SdkInternalList)describeImagesRequest.filters()).isEmpty() || !describeImagesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describeImagesRequestFiltersListValue : describeImagesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describeImagesRequestFiltersListValue).name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)((Filter)describeImagesRequestFiltersListValue).name()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describeImagesRequestFiltersListValue).values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeImagesRequestImageIdsList = (SdkInternalList)describeImagesRequest.imageIds()).isEmpty() || !describeImagesRequestImageIdsList.isAutoConstruct()) {
            int imageIdsListIndex = 1;
            for (String describeImagesRequestImageIdsListValue : describeImagesRequestImageIdsList) {
                if (describeImagesRequestImageIdsListValue != null) {
                    request.addParameter("ImageId." + imageIdsListIndex, StringUtils.fromString((String)describeImagesRequestImageIdsListValue));
                }
                ++imageIdsListIndex;
            }
        }
        if (!(describeImagesRequestOwnersList = (SdkInternalList)describeImagesRequest.owners()).isEmpty() || !describeImagesRequestOwnersList.isAutoConstruct()) {
            int ownersListIndex = 1;
            for (String describeImagesRequestOwnersListValue : describeImagesRequestOwnersList) {
                if (describeImagesRequestOwnersListValue != null) {
                    request.addParameter("Owner." + ownersListIndex, StringUtils.fromString((String)describeImagesRequestOwnersListValue));
                }
                ++ownersListIndex;
            }
        }
        return request;
    }
}

