/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeFpgaImagesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeFpgaImagesRequestMarshaller
implements Marshaller<Request<DescribeFpgaImagesRequest>, DescribeFpgaImagesRequest> {
    public Request<DescribeFpgaImagesRequest> marshall(DescribeFpgaImagesRequest describeFpgaImagesRequest) {
        SdkInternalList describeFpgaImagesRequestFiltersList;
        SdkInternalList describeFpgaImagesRequestOwnersList;
        if (describeFpgaImagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFpgaImagesRequest, "EC2Client");
        request.addParameter("Action", "DescribeFpgaImages");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeFpgaImagesRequestFpgaImageIdsList = (SdkInternalList)describeFpgaImagesRequest.fpgaImageIds();
        if (!describeFpgaImagesRequestFpgaImageIdsList.isEmpty() || !describeFpgaImagesRequestFpgaImageIdsList.isAutoConstruct()) {
            int fpgaImageIdsListIndex = 1;
            for (Object describeFpgaImagesRequestFpgaImageIdsListValue : describeFpgaImagesRequestFpgaImageIdsList) {
                if (describeFpgaImagesRequestFpgaImageIdsListValue != null) {
                    request.addParameter("FpgaImageId." + fpgaImageIdsListIndex, StringUtils.fromString((String)describeFpgaImagesRequestFpgaImageIdsListValue));
                }
                ++fpgaImageIdsListIndex;
            }
        }
        if (!(describeFpgaImagesRequestOwnersList = (SdkInternalList)describeFpgaImagesRequest.owners()).isEmpty() || !describeFpgaImagesRequestOwnersList.isAutoConstruct()) {
            int ownersListIndex = 1;
            for (String describeFpgaImagesRequestOwnersListValue : describeFpgaImagesRequestOwnersList) {
                if (describeFpgaImagesRequestOwnersListValue != null) {
                    request.addParameter("Owner." + ownersListIndex, StringUtils.fromString((String)describeFpgaImagesRequestOwnersListValue));
                }
                ++ownersListIndex;
            }
        }
        if (!(describeFpgaImagesRequestFiltersList = (SdkInternalList)describeFpgaImagesRequest.filters()).isEmpty() || !describeFpgaImagesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeFpgaImagesRequestFiltersListValue : describeFpgaImagesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeFpgaImagesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeFpgaImagesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeFpgaImagesRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeFpgaImagesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeFpgaImagesRequest.nextToken()));
        }
        if (describeFpgaImagesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeFpgaImagesRequest.maxResults()));
        }
        return request;
    }
}

