/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeDhcpOptionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeDhcpOptionsRequestMarshaller
implements Marshaller<Request<DescribeDhcpOptionsRequest>, DescribeDhcpOptionsRequest> {
    public Request<DescribeDhcpOptionsRequest> marshall(DescribeDhcpOptionsRequest describeDhcpOptionsRequest) {
        SdkInternalList describeDhcpOptionsRequestFiltersList;
        if (describeDhcpOptionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeDhcpOptionsRequest, "EC2Client");
        request.addParameter("Action", "DescribeDhcpOptions");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeDhcpOptionsRequestDhcpOptionsIdsList = (SdkInternalList)describeDhcpOptionsRequest.dhcpOptionsIds();
        if (!describeDhcpOptionsRequestDhcpOptionsIdsList.isEmpty() || !describeDhcpOptionsRequestDhcpOptionsIdsList.isAutoConstruct()) {
            int dhcpOptionsIdsListIndex = 1;
            for (String describeDhcpOptionsRequestDhcpOptionsIdsListValue : describeDhcpOptionsRequestDhcpOptionsIdsList) {
                if (describeDhcpOptionsRequestDhcpOptionsIdsListValue != null) {
                    request.addParameter("DhcpOptionsId." + dhcpOptionsIdsListIndex, StringUtils.fromString((String)describeDhcpOptionsRequestDhcpOptionsIdsListValue));
                }
                ++dhcpOptionsIdsListIndex;
            }
        }
        if (!(describeDhcpOptionsRequestFiltersList = (SdkInternalList)describeDhcpOptionsRequest.filters()).isEmpty() || !describeDhcpOptionsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeDhcpOptionsRequestFiltersListValue : describeDhcpOptionsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeDhcpOptionsRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeDhcpOptionsRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeDhcpOptionsRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

