/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeConversionTasksRequestMarshaller
implements Marshaller<Request<DescribeConversionTasksRequest>, DescribeConversionTasksRequest> {
    public Request<DescribeConversionTasksRequest> marshall(DescribeConversionTasksRequest describeConversionTasksRequest) {
        if (describeConversionTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeConversionTasksRequest, "EC2Client");
        request.addParameter("Action", "DescribeConversionTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeConversionTasksRequestConversionTaskIdsList = (SdkInternalList)describeConversionTasksRequest.conversionTaskIds();
        if (!describeConversionTasksRequestConversionTaskIdsList.isEmpty() || !describeConversionTasksRequestConversionTaskIdsList.isAutoConstruct()) {
            int conversionTaskIdsListIndex = 1;
            for (String describeConversionTasksRequestConversionTaskIdsListValue : describeConversionTasksRequestConversionTaskIdsList) {
                if (describeConversionTasksRequestConversionTaskIdsListValue != null) {
                    request.addParameter("ConversionTaskId." + conversionTaskIdsListIndex, StringUtils.fromString((String)describeConversionTasksRequestConversionTaskIdsListValue));
                }
                ++conversionTaskIdsListIndex;
            }
        }
        return request;
    }
}

