/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeClassicLinkInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeClassicLinkInstancesRequestMarshaller
implements Marshaller<Request<DescribeClassicLinkInstancesRequest>, DescribeClassicLinkInstancesRequest> {
    public Request<DescribeClassicLinkInstancesRequest> marshall(DescribeClassicLinkInstancesRequest describeClassicLinkInstancesRequest) {
        SdkInternalList describeClassicLinkInstancesRequestInstanceIdsList;
        if (describeClassicLinkInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClassicLinkInstancesRequest, "EC2Client");
        request.addParameter("Action", "DescribeClassicLinkInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeClassicLinkInstancesRequestFiltersList = (SdkInternalList)describeClassicLinkInstancesRequest.filters();
        if (!describeClassicLinkInstancesRequestFiltersList.isEmpty() || !describeClassicLinkInstancesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeClassicLinkInstancesRequestFiltersListValue : describeClassicLinkInstancesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeClassicLinkInstancesRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeClassicLinkInstancesRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeClassicLinkInstancesRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeClassicLinkInstancesRequestInstanceIdsList = (SdkInternalList)describeClassicLinkInstancesRequest.instanceIds()).isEmpty() || !describeClassicLinkInstancesRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String describeClassicLinkInstancesRequestInstanceIdsListValue : describeClassicLinkInstancesRequestInstanceIdsList) {
                if (describeClassicLinkInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)describeClassicLinkInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (describeClassicLinkInstancesRequest.maxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeClassicLinkInstancesRequest.maxResults()));
        }
        if (describeClassicLinkInstancesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeClassicLinkInstancesRequest.nextToken()));
        }
        return request;
    }
}

