/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.util.StringUtils;

public class DescribeBundleTasksRequestMarshaller
implements Marshaller<Request<DescribeBundleTasksRequest>, DescribeBundleTasksRequest> {
    public Request<DescribeBundleTasksRequest> marshall(DescribeBundleTasksRequest describeBundleTasksRequest) {
        SdkInternalList describeBundleTasksRequestFiltersList;
        if (describeBundleTasksRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeBundleTasksRequest, "EC2Client");
        request.addParameter("Action", "DescribeBundleTasks");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeBundleTasksRequestBundleIdsList = (SdkInternalList)describeBundleTasksRequest.bundleIds();
        if (!describeBundleTasksRequestBundleIdsList.isEmpty() || !describeBundleTasksRequestBundleIdsList.isAutoConstruct()) {
            int bundleIdsListIndex = 1;
            for (String describeBundleTasksRequestBundleIdsListValue : describeBundleTasksRequestBundleIdsList) {
                if (describeBundleTasksRequestBundleIdsListValue != null) {
                    request.addParameter("BundleId." + bundleIdsListIndex, StringUtils.fromString((String)describeBundleTasksRequestBundleIdsListValue));
                }
                ++bundleIdsListIndex;
            }
        }
        if (!(describeBundleTasksRequestFiltersList = (SdkInternalList)describeBundleTasksRequest.filters()).isEmpty() || !describeBundleTasksRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeBundleTasksRequestFiltersListValue : describeBundleTasksRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeBundleTasksRequestFiltersListValue.name() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeBundleTasksRequestFiltersListValue.name()));
                }
                if (!(filterValuesList = (SdkInternalList)describeBundleTasksRequestFiltersListValue.values()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

