/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateVolumeRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.util.StringUtils;

public class CreateVolumeRequestMarshaller
implements Marshaller<Request<CreateVolumeRequest>, CreateVolumeRequest> {
    public Request<CreateVolumeRequest> marshall(CreateVolumeRequest createVolumeRequest) {
        SdkInternalList createVolumeRequestTagSpecificationsList;
        if (createVolumeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVolumeRequest, "EC2Client");
        request.addParameter("Action", "CreateVolume");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVolumeRequest.availabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)createVolumeRequest.availabilityZone()));
        }
        if (createVolumeRequest.encrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean((Boolean)createVolumeRequest.encrypted()));
        }
        if (createVolumeRequest.iops() != null) {
            request.addParameter("Iops", StringUtils.fromInteger((Integer)createVolumeRequest.iops()));
        }
        if (createVolumeRequest.kmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString((String)createVolumeRequest.kmsKeyId()));
        }
        if (createVolumeRequest.size() != null) {
            request.addParameter("Size", StringUtils.fromInteger((Integer)createVolumeRequest.size()));
        }
        if (createVolumeRequest.snapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)createVolumeRequest.snapshotId()));
        }
        if (createVolumeRequest.volumeType() != null) {
            request.addParameter("VolumeType", StringUtils.fromString((String)createVolumeRequest.volumeType()));
        }
        if (!(createVolumeRequestTagSpecificationsList = (SdkInternalList)createVolumeRequest.tagSpecifications()).isEmpty() || !createVolumeRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVolumeRequestTagSpecificationsListValue : createVolumeRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVolumeRequestTagSpecificationsListValue.resourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createVolumeRequestTagSpecificationsListValue.resourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVolumeRequestTagSpecificationsListValue.tags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.key() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.key()));
                        }
                        if (tagSpecificationTagsListValue.value() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.value()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

