/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CreateCustomerGatewayRequest;
import software.amazon.awssdk.util.StringUtils;

public class CreateCustomerGatewayRequestMarshaller
implements Marshaller<Request<CreateCustomerGatewayRequest>, CreateCustomerGatewayRequest> {
    public Request<CreateCustomerGatewayRequest> marshall(CreateCustomerGatewayRequest createCustomerGatewayRequest) {
        if (createCustomerGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCustomerGatewayRequest, "EC2Client");
        request.addParameter("Action", "CreateCustomerGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCustomerGatewayRequest.bgpAsn() != null) {
            request.addParameter("BgpAsn", StringUtils.fromInteger((Integer)createCustomerGatewayRequest.bgpAsn()));
        }
        if (createCustomerGatewayRequest.publicIp() != null) {
            request.addParameter("IpAddress", StringUtils.fromString((String)createCustomerGatewayRequest.publicIp()));
        }
        if (createCustomerGatewayRequest.type() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createCustomerGatewayRequest.type()));
        }
        return request;
    }
}

