/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ClassicLinkInstance;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class ClassicLinkInstanceUnmarshaller
implements Unmarshaller<ClassicLinkInstance, StaxUnmarshallerContext> {
    private static ClassicLinkInstanceUnmarshaller INSTANCE;

    public ClassicLinkInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ClassicLinkInstance.Builder classicLinkInstance = ClassicLinkInstance.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("groupSet", targetDepth)) {
                    classicLinkInstance.groups(new ArrayList<GroupIdentifier>());
                    continue;
                }
                if (context.testExpression("groupSet/item", targetDepth)) {
                    classicLinkInstance.groups(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceId", targetDepth)) {
                    classicLinkInstance.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet", targetDepth)) {
                    classicLinkInstance.tags(new ArrayList<Tag>());
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    classicLinkInstance.tags(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpcId", targetDepth)) continue;
                classicLinkInstance.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ClassicLinkInstance)classicLinkInstance.build();
    }

    public static ClassicLinkInstanceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClassicLinkInstanceUnmarshaller();
        }
        return INSTANCE;
    }
}

