/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.CancelSpotFleetRequestsRequest;
import software.amazon.awssdk.util.StringUtils;

public class CancelSpotFleetRequestsRequestMarshaller
implements Marshaller<Request<CancelSpotFleetRequestsRequest>, CancelSpotFleetRequestsRequest> {
    public Request<CancelSpotFleetRequestsRequest> marshall(CancelSpotFleetRequestsRequest cancelSpotFleetRequestsRequest) {
        if (cancelSpotFleetRequestsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)cancelSpotFleetRequestsRequest, "EC2Client");
        request.addParameter("Action", "CancelSpotFleetRequests");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList cancelSpotFleetRequestsRequestSpotFleetRequestIdsList = (SdkInternalList)cancelSpotFleetRequestsRequest.spotFleetRequestIds();
        if (!cancelSpotFleetRequestsRequestSpotFleetRequestIdsList.isEmpty() || !cancelSpotFleetRequestsRequestSpotFleetRequestIdsList.isAutoConstruct()) {
            int spotFleetRequestIdsListIndex = 1;
            for (String cancelSpotFleetRequestsRequestSpotFleetRequestIdsListValue : cancelSpotFleetRequestsRequestSpotFleetRequestIdsList) {
                if (cancelSpotFleetRequestsRequestSpotFleetRequestIdsListValue != null) {
                    request.addParameter("SpotFleetRequestId." + spotFleetRequestIdsListIndex, StringUtils.fromString((String)cancelSpotFleetRequestsRequestSpotFleetRequestIdsListValue));
                }
                ++spotFleetRequestIdsListIndex;
            }
        }
        if (cancelSpotFleetRequestsRequest.terminateInstances() != null) {
            request.addParameter("TerminateInstances", StringUtils.fromBoolean((Boolean)cancelSpotFleetRequestsRequest.terminateInstances()));
        }
        return request;
    }
}

