/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import software.amazon.awssdk.services.ec2.model.IpPermission;
import software.amazon.awssdk.services.ec2.model.IpRange;
import software.amazon.awssdk.services.ec2.model.Ipv6Range;
import software.amazon.awssdk.services.ec2.model.PrefixListId;
import software.amazon.awssdk.services.ec2.model.UserIdGroupPair;
import software.amazon.awssdk.util.StringUtils;

public class AuthorizeSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<AuthorizeSecurityGroupIngressRequest>, AuthorizeSecurityGroupIngressRequest> {
    public Request<AuthorizeSecurityGroupIngressRequest> marshall(AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) {
        SdkInternalList authorizeSecurityGroupIngressRequestIpPermissionsList;
        if (authorizeSecurityGroupIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeSecurityGroupIngressRequest, "EC2Client");
        request.addParameter("Action", "AuthorizeSecurityGroupIngress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeSecurityGroupIngressRequest.cidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.cidrIp()));
        }
        if (authorizeSecurityGroupIngressRequest.fromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupIngressRequest.fromPort()));
        }
        if (authorizeSecurityGroupIngressRequest.groupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.groupId()));
        }
        if (authorizeSecurityGroupIngressRequest.groupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.groupName()));
        }
        if (!(authorizeSecurityGroupIngressRequestIpPermissionsList = (SdkInternalList)authorizeSecurityGroupIngressRequest.ipPermissions()).isEmpty() || !authorizeSecurityGroupIngressRequestIpPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission authorizeSecurityGroupIngressRequestIpPermissionsListValue : authorizeSecurityGroupIngressRequestIpPermissionsList) {
                SdkInternalList ipPermissionIpv4RangesList;
                SdkInternalList ipPermissionUserIdGroupPairsList;
                SdkInternalList ipPermissionPrefixListIdsList;
                SdkInternalList ipPermissionIpv6RangesList;
                if (authorizeSecurityGroupIngressRequestIpPermissionsListValue.fromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupIngressRequestIpPermissionsListValue.fromPort()));
                }
                if (authorizeSecurityGroupIngressRequestIpPermissionsListValue.ipProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)authorizeSecurityGroupIngressRequestIpPermissionsListValue.ipProtocol()));
                }
                if (!(ipPermissionIpv6RangesList = (SdkInternalList)authorizeSecurityGroupIngressRequestIpPermissionsListValue.ipv6Ranges()).isEmpty() || !ipPermissionIpv6RangesList.isAutoConstruct()) {
                    int ipv6RangesListIndex = 1;
                    for (Object ipPermissionIpv6RangesListValue : ipPermissionIpv6RangesList) {
                        if (((Ipv6Range)ipPermissionIpv6RangesListValue).cidrIpv6() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Ipv6Ranges." + ipv6RangesListIndex + ".CidrIpv6", StringUtils.fromString((String)((Ipv6Range)ipPermissionIpv6RangesListValue).cidrIpv6()));
                        }
                        ++ipv6RangesListIndex;
                    }
                }
                if (!(ipPermissionPrefixListIdsList = (SdkInternalList)authorizeSecurityGroupIngressRequestIpPermissionsListValue.prefixListIds()).isEmpty() || !ipPermissionPrefixListIdsList.isAutoConstruct()) {
                    Object ipPermissionIpv6RangesListValue;
                    int prefixListIdsListIndex = 1;
                    ipPermissionIpv6RangesListValue = ipPermissionPrefixListIdsList.iterator();
                    while (ipPermissionIpv6RangesListValue.hasNext()) {
                        PrefixListId ipPermissionPrefixListIdsListValue = (PrefixListId)ipPermissionIpv6RangesListValue.next();
                        if (ipPermissionPrefixListIdsListValue.prefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)ipPermissionPrefixListIdsListValue.prefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                if (authorizeSecurityGroupIngressRequestIpPermissionsListValue.toPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupIngressRequestIpPermissionsListValue.toPort()));
                }
                if (!(ipPermissionUserIdGroupPairsList = (SdkInternalList)authorizeSecurityGroupIngressRequestIpPermissionsListValue.userIdGroupPairs()).isEmpty() || !ipPermissionUserIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (UserIdGroupPair ipPermissionUserIdGroupPairsListValue : ipPermissionUserIdGroupPairsList) {
                        if (ipPermissionUserIdGroupPairsListValue.groupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.groupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.groupName()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.peeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.peeringStatus()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.userId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.userId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcId()));
                        }
                        if (ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString((String)ipPermissionUserIdGroupPairsListValue.vpcPeeringConnectionId()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipPermissionIpv4RangesList = (SdkInternalList)authorizeSecurityGroupIngressRequestIpPermissionsListValue.ipv4Ranges()).isEmpty() || !ipPermissionIpv4RangesList.isAutoConstruct()) {
                    int ipv4RangesListIndex = 1;
                    for (IpRange ipPermissionIpv4RangesListValue : ipPermissionIpv4RangesList) {
                        if (ipPermissionIpv4RangesListValue.cidrIp() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipv4RangesListIndex + ".CidrIp", StringUtils.fromString((String)ipPermissionIpv4RangesListValue.cidrIp()));
                        }
                        ++ipv4RangesListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        if (authorizeSecurityGroupIngressRequest.ipProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.ipProtocol()));
        }
        if (authorizeSecurityGroupIngressRequest.sourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.sourceSecurityGroupName()));
        }
        if (authorizeSecurityGroupIngressRequest.sourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.sourceSecurityGroupOwnerId()));
        }
        if (authorizeSecurityGroupIngressRequest.toPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupIngressRequest.toPort()));
        }
        return request;
    }
}

