/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.ec2.model.AttachClassicLinkVpcRequest;
import software.amazon.awssdk.util.StringUtils;

public class AttachClassicLinkVpcRequestMarshaller
implements Marshaller<Request<AttachClassicLinkVpcRequest>, AttachClassicLinkVpcRequest> {
    public Request<AttachClassicLinkVpcRequest> marshall(AttachClassicLinkVpcRequest attachClassicLinkVpcRequest) {
        if (attachClassicLinkVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachClassicLinkVpcRequest, "EC2Client");
        request.addParameter("Action", "AttachClassicLinkVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList attachClassicLinkVpcRequestGroupsList = (SdkInternalList)attachClassicLinkVpcRequest.groups();
        if (!attachClassicLinkVpcRequestGroupsList.isEmpty() || !attachClassicLinkVpcRequestGroupsList.isAutoConstruct()) {
            int groupsListIndex = 1;
            for (String attachClassicLinkVpcRequestGroupsListValue : attachClassicLinkVpcRequestGroupsList) {
                if (attachClassicLinkVpcRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)attachClassicLinkVpcRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (attachClassicLinkVpcRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)attachClassicLinkVpcRequest.instanceId()));
        }
        if (attachClassicLinkVpcRequest.vpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)attachClassicLinkVpcRequest.vpcId()));
        }
        return request;
    }
}

