/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.ActiveInstance;

public class ActiveInstanceUnmarshaller
implements Unmarshaller<ActiveInstance, StaxUnmarshallerContext> {
    private static ActiveInstanceUnmarshaller INSTANCE;

    public ActiveInstance unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        ActiveInstance.Builder activeInstance = ActiveInstance.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("instanceId", targetDepth)) {
                    activeInstance.instanceId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceType", targetDepth)) {
                    activeInstance.instanceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("spotInstanceRequestId", targetDepth)) {
                    activeInstance.spotInstanceRequestId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instanceHealth", targetDepth)) continue;
                activeInstance.instanceHealth(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (ActiveInstance)activeInstance.build();
    }

    public static ActiveInstanceUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActiveInstanceUnmarshaller();
        }
        return INSTANCE;
    }
}

