/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.VolumeStatusAction;
import software.amazon.awssdk.services.ec2.model.VolumeStatusActionsListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusEvent;
import software.amazon.awssdk.services.ec2.model.VolumeStatusEventsListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusInfo;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeStatusItem
implements ToCopyableBuilder<Builder, VolumeStatusItem> {
    private final List<VolumeStatusAction> actions;
    private final String availabilityZone;
    private final List<VolumeStatusEvent> events;
    private final String volumeId;
    private final VolumeStatusInfo volumeStatus;

    private VolumeStatusItem(BuilderImpl builder) {
        this.actions = builder.actions;
        this.availabilityZone = builder.availabilityZone;
        this.events = builder.events;
        this.volumeId = builder.volumeId;
        this.volumeStatus = builder.volumeStatus;
    }

    public List<VolumeStatusAction> actions() {
        return this.actions;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public List<VolumeStatusEvent> events() {
        return this.events;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public VolumeStatusInfo volumeStatus() {
        return this.volumeStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.actions() == null ? 0 : this.actions().hashCode());
        hashCode = 31 * hashCode + (this.availabilityZone() == null ? 0 : this.availabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.events() == null ? 0 : this.events().hashCode());
        hashCode = 31 * hashCode + (this.volumeId() == null ? 0 : this.volumeId().hashCode());
        hashCode = 31 * hashCode + (this.volumeStatus() == null ? 0 : this.volumeStatus().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusItem)) {
            return false;
        }
        VolumeStatusItem other = (VolumeStatusItem)obj;
        if (other.actions() == null ^ this.actions() == null) {
            return false;
        }
        if (other.actions() != null && !other.actions().equals(this.actions())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.events() == null ^ this.events() == null) {
            return false;
        }
        if (other.events() != null && !other.events().equals(this.events())) {
            return false;
        }
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.volumeStatus() == null ^ this.volumeStatus() == null) {
            return false;
        }
        return other.volumeStatus() == null || other.volumeStatus().equals(this.volumeStatus());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.actions() != null) {
            sb.append("Actions: ").append(this.actions()).append(",");
        }
        if (this.availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.availabilityZone()).append(",");
        }
        if (this.events() != null) {
            sb.append("Events: ").append(this.events()).append(",");
        }
        if (this.volumeId() != null) {
            sb.append("VolumeId: ").append(this.volumeId()).append(",");
        }
        if (this.volumeStatus() != null) {
            sb.append("VolumeStatus: ").append(this.volumeStatus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<VolumeStatusAction> actions = new SdkInternalList();
        private String availabilityZone;
        private List<VolumeStatusEvent> events = new SdkInternalList();
        private String volumeId;
        private VolumeStatusInfo volumeStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusItem model) {
            this.setActions(model.actions);
            this.setAvailabilityZone(model.availabilityZone);
            this.setEvents(model.events);
            this.setVolumeId(model.volumeId);
            this.setVolumeStatus(model.volumeStatus);
        }

        public final Collection<VolumeStatusAction> getActions() {
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<VolumeStatusAction> actions) {
            this.actions = VolumeStatusActionsListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(VolumeStatusAction ... actions) {
            if (this.actions == null) {
                this.actions = new SdkInternalList(actions.length);
            }
            for (VolumeStatusAction e : actions) {
                this.actions.add(e);
            }
            return this;
        }

        public final void setActions(Collection<VolumeStatusAction> actions) {
            this.actions = VolumeStatusActionsListCopier.copy(actions);
        }

        @SafeVarargs
        public final void setActions(VolumeStatusAction ... actions) {
            if (this.actions == null) {
                this.actions = new SdkInternalList(actions.length);
            }
            for (VolumeStatusAction e : actions) {
                this.actions.add(e);
            }
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<VolumeStatusEvent> getEvents() {
            return this.events;
        }

        @Override
        public final Builder events(Collection<VolumeStatusEvent> events) {
            this.events = VolumeStatusEventsListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(VolumeStatusEvent ... events) {
            if (this.events == null) {
                this.events = new SdkInternalList(events.length);
            }
            for (VolumeStatusEvent e : events) {
                this.events.add(e);
            }
            return this;
        }

        public final void setEvents(Collection<VolumeStatusEvent> events) {
            this.events = VolumeStatusEventsListCopier.copy(events);
        }

        @SafeVarargs
        public final void setEvents(VolumeStatusEvent ... events) {
            if (this.events == null) {
                this.events = new SdkInternalList(events.length);
            }
            for (VolumeStatusEvent e : events) {
                this.events.add(e);
            }
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final VolumeStatusInfo getVolumeStatus() {
            return this.volumeStatus;
        }

        @Override
        public final Builder volumeStatus(VolumeStatusInfo volumeStatus) {
            this.volumeStatus = volumeStatus;
            return this;
        }

        public final void setVolumeStatus(VolumeStatusInfo volumeStatus) {
            this.volumeStatus = volumeStatus;
        }

        public VolumeStatusItem build() {
            return new VolumeStatusItem(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeStatusItem> {
        public Builder actions(Collection<VolumeStatusAction> var1);

        public Builder actions(VolumeStatusAction ... var1);

        public Builder availabilityZone(String var1);

        public Builder events(Collection<VolumeStatusEvent> var1);

        public Builder events(VolumeStatusEvent ... var1);

        public Builder volumeId(String var1);

        public Builder volumeStatus(VolumeStatusInfo var1);
    }
}

