/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.VolumeStatusDetails;
import software.amazon.awssdk.services.ec2.model.VolumeStatusDetailsListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeStatusInfoStatus;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeStatusInfo
implements ToCopyableBuilder<Builder, VolumeStatusInfo> {
    private final List<VolumeStatusDetails> details;
    private final String status;

    private VolumeStatusInfo(BuilderImpl builder) {
        this.details = builder.details;
        this.status = builder.status;
    }

    public List<VolumeStatusDetails> details() {
        return this.details;
    }

    public String status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.details() == null ? 0 : this.details().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeStatusInfo)) {
            return false;
        }
        VolumeStatusInfo other = (VolumeStatusInfo)obj;
        if (other.details() == null ^ this.details() == null) {
            return false;
        }
        if (other.details() != null && !other.details().equals(this.details())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        return other.status() == null || other.status().equals(this.status());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.details() != null) {
            sb.append("Details: ").append(this.details()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<VolumeStatusDetails> details = new SdkInternalList();
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeStatusInfo model) {
            this.setDetails(model.details);
            this.setStatus(model.status);
        }

        public final Collection<VolumeStatusDetails> getDetails() {
            return this.details;
        }

        @Override
        public final Builder details(Collection<VolumeStatusDetails> details) {
            this.details = VolumeStatusDetailsListCopier.copy(details);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder details(VolumeStatusDetails ... details) {
            if (this.details == null) {
                this.details = new SdkInternalList(details.length);
            }
            for (VolumeStatusDetails e : details) {
                this.details.add(e);
            }
            return this;
        }

        public final void setDetails(Collection<VolumeStatusDetails> details) {
            this.details = VolumeStatusDetailsListCopier.copy(details);
        }

        @SafeVarargs
        public final void setDetails(VolumeStatusDetails ... details) {
            if (this.details == null) {
                this.details = new SdkInternalList(details.length);
            }
            for (VolumeStatusDetails e : details) {
                this.details.add(e);
            }
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VolumeStatusInfoStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final void setStatus(VolumeStatusInfoStatus status) {
            this.status(status.toString());
        }

        public VolumeStatusInfo build() {
            return new VolumeStatusInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeStatusInfo> {
        public Builder details(Collection<VolumeStatusDetails> var1);

        public Builder details(VolumeStatusDetails ... var1);

        public Builder status(String var1);

        public Builder status(VolumeStatusInfoStatus var1);
    }
}

