/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.PrivateIpAddressStringListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UnassignPrivateIpAddressesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UnassignPrivateIpAddressesRequest> {
    private final String networkInterfaceId;
    private final List<String> privateIpAddresses;

    private UnassignPrivateIpAddressesRequest(BuilderImpl builder) {
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddresses = builder.privateIpAddresses;
    }

    public String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.networkInterfaceId() == null ? 0 : this.networkInterfaceId().hashCode());
        hashCode = 31 * hashCode + (this.privateIpAddresses() == null ? 0 : this.privateIpAddresses().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnassignPrivateIpAddressesRequest)) {
            return false;
        }
        UnassignPrivateIpAddressesRequest other = (UnassignPrivateIpAddressesRequest)((Object)obj);
        if (other.networkInterfaceId() == null ^ this.networkInterfaceId() == null) {
            return false;
        }
        if (other.networkInterfaceId() != null && !other.networkInterfaceId().equals(this.networkInterfaceId())) {
            return false;
        }
        if (other.privateIpAddresses() == null ^ this.privateIpAddresses() == null) {
            return false;
        }
        return other.privateIpAddresses() == null || other.privateIpAddresses().equals(this.privateIpAddresses());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.networkInterfaceId() != null) {
            sb.append("NetworkInterfaceId: ").append(this.networkInterfaceId()).append(",");
        }
        if (this.privateIpAddresses() != null) {
            sb.append("PrivateIpAddresses: ").append(this.privateIpAddresses()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private List<String> privateIpAddresses = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(UnassignPrivateIpAddressesRequest model) {
            this.setNetworkInterfaceId(model.networkInterfaceId);
            this.setPrivateIpAddresses(model.privateIpAddresses);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        public final Collection<String> getPrivateIpAddresses() {
            return this.privateIpAddresses;
        }

        @Override
        public final Builder privateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(String ... privateIpAddresses) {
            if (this.privateIpAddresses == null) {
                this.privateIpAddresses = new SdkInternalList(privateIpAddresses.length);
            }
            for (String e : privateIpAddresses) {
                this.privateIpAddresses.add(e);
            }
            return this;
        }

        public final void setPrivateIpAddresses(Collection<String> privateIpAddresses) {
            this.privateIpAddresses = PrivateIpAddressStringListCopier.copy(privateIpAddresses);
        }

        @SafeVarargs
        public final void setPrivateIpAddresses(String ... privateIpAddresses) {
            if (this.privateIpAddresses == null) {
                this.privateIpAddresses = new SdkInternalList(privateIpAddresses.length);
            }
            for (String e : privateIpAddresses) {
                this.privateIpAddresses.add(e);
            }
        }

        public UnassignPrivateIpAddressesRequest build() {
            return new UnassignPrivateIpAddressesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UnassignPrivateIpAddressesRequest> {
        public Builder networkInterfaceId(String var1);

        public Builder privateIpAddresses(Collection<String> var1);

        public Builder privateIpAddresses(String ... var1);
    }
}

