/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.ec2.model.PropagatingVgw;
import software.amazon.awssdk.services.ec2.model.PropagatingVgwListCopier;
import software.amazon.awssdk.services.ec2.model.Route;
import software.amazon.awssdk.services.ec2.model.RouteListCopier;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociation;
import software.amazon.awssdk.services.ec2.model.RouteTableAssociationListCopier;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RouteTable
implements ToCopyableBuilder<Builder, RouteTable> {
    private final List<RouteTableAssociation> associations;
    private final List<PropagatingVgw> propagatingVgws;
    private final String routeTableId;
    private final List<Route> routes;
    private final List<Tag> tags;
    private final String vpcId;

    private RouteTable(BuilderImpl builder) {
        this.associations = builder.associations;
        this.propagatingVgws = builder.propagatingVgws;
        this.routeTableId = builder.routeTableId;
        this.routes = builder.routes;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    public List<RouteTableAssociation> associations() {
        return this.associations;
    }

    public List<PropagatingVgw> propagatingVgws() {
        return this.propagatingVgws;
    }

    public String routeTableId() {
        return this.routeTableId;
    }

    public List<Route> routes() {
        return this.routes;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.associations() == null ? 0 : this.associations().hashCode());
        hashCode = 31 * hashCode + (this.propagatingVgws() == null ? 0 : this.propagatingVgws().hashCode());
        hashCode = 31 * hashCode + (this.routeTableId() == null ? 0 : this.routeTableId().hashCode());
        hashCode = 31 * hashCode + (this.routes() == null ? 0 : this.routes().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.vpcId() == null ? 0 : this.vpcId().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RouteTable)) {
            return false;
        }
        RouteTable other = (RouteTable)obj;
        if (other.associations() == null ^ this.associations() == null) {
            return false;
        }
        if (other.associations() != null && !other.associations().equals(this.associations())) {
            return false;
        }
        if (other.propagatingVgws() == null ^ this.propagatingVgws() == null) {
            return false;
        }
        if (other.propagatingVgws() != null && !other.propagatingVgws().equals(this.propagatingVgws())) {
            return false;
        }
        if (other.routeTableId() == null ^ this.routeTableId() == null) {
            return false;
        }
        if (other.routeTableId() != null && !other.routeTableId().equals(this.routeTableId())) {
            return false;
        }
        if (other.routes() == null ^ this.routes() == null) {
            return false;
        }
        if (other.routes() != null && !other.routes().equals(this.routes())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        return other.vpcId() == null || other.vpcId().equals(this.vpcId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.associations() != null) {
            sb.append("Associations: ").append(this.associations()).append(",");
        }
        if (this.propagatingVgws() != null) {
            sb.append("PropagatingVgws: ").append(this.propagatingVgws()).append(",");
        }
        if (this.routeTableId() != null) {
            sb.append("RouteTableId: ").append(this.routeTableId()).append(",");
        }
        if (this.routes() != null) {
            sb.append("Routes: ").append(this.routes()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.vpcId() != null) {
            sb.append("VpcId: ").append(this.vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<RouteTableAssociation> associations = new SdkInternalList();
        private List<PropagatingVgw> propagatingVgws = new SdkInternalList();
        private String routeTableId;
        private List<Route> routes = new SdkInternalList();
        private List<Tag> tags = new SdkInternalList();
        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(RouteTable model) {
            this.setAssociations(model.associations);
            this.setPropagatingVgws(model.propagatingVgws);
            this.setRouteTableId(model.routeTableId);
            this.setRoutes(model.routes);
            this.setTags(model.tags);
            this.setVpcId(model.vpcId);
        }

        public final Collection<RouteTableAssociation> getAssociations() {
            return this.associations;
        }

        @Override
        public final Builder associations(Collection<RouteTableAssociation> associations) {
            this.associations = RouteTableAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(RouteTableAssociation ... associations) {
            if (this.associations == null) {
                this.associations = new SdkInternalList(associations.length);
            }
            for (RouteTableAssociation e : associations) {
                this.associations.add(e);
            }
            return this;
        }

        public final void setAssociations(Collection<RouteTableAssociation> associations) {
            this.associations = RouteTableAssociationListCopier.copy(associations);
        }

        @SafeVarargs
        public final void setAssociations(RouteTableAssociation ... associations) {
            if (this.associations == null) {
                this.associations = new SdkInternalList(associations.length);
            }
            for (RouteTableAssociation e : associations) {
                this.associations.add(e);
            }
        }

        public final Collection<PropagatingVgw> getPropagatingVgws() {
            return this.propagatingVgws;
        }

        @Override
        public final Builder propagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copy(propagatingVgws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgws(PropagatingVgw ... propagatingVgws) {
            if (this.propagatingVgws == null) {
                this.propagatingVgws = new SdkInternalList(propagatingVgws.length);
            }
            for (PropagatingVgw e : propagatingVgws) {
                this.propagatingVgws.add(e);
            }
            return this;
        }

        public final void setPropagatingVgws(Collection<PropagatingVgw> propagatingVgws) {
            this.propagatingVgws = PropagatingVgwListCopier.copy(propagatingVgws);
        }

        @SafeVarargs
        public final void setPropagatingVgws(PropagatingVgw ... propagatingVgws) {
            if (this.propagatingVgws == null) {
                this.propagatingVgws = new SdkInternalList(propagatingVgws.length);
            }
            for (PropagatingVgw e : propagatingVgws) {
                this.propagatingVgws.add(e);
            }
        }

        public final String getRouteTableId() {
            return this.routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        public final Collection<Route> getRoutes() {
            return this.routes;
        }

        @Override
        public final Builder routes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routes(Route ... routes) {
            if (this.routes == null) {
                this.routes = new SdkInternalList(routes.length);
            }
            for (Route e : routes) {
                this.routes.add(e);
            }
            return this;
        }

        public final void setRoutes(Collection<Route> routes) {
            this.routes = RouteListCopier.copy(routes);
        }

        @SafeVarargs
        public final void setRoutes(Route ... routes) {
            if (this.routes == null) {
                this.routes = new SdkInternalList(routes.length);
            }
            for (Route e : routes) {
                this.routes.add(e);
            }
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public RouteTable build() {
            return new RouteTable(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RouteTable> {
        public Builder associations(Collection<RouteTableAssociation> var1);

        public Builder associations(RouteTableAssociation ... var1);

        public Builder propagatingVgws(Collection<PropagatingVgw> var1);

        public Builder propagatingVgws(PropagatingVgw ... var1);

        public Builder routeTableId(String var1);

        public Builder routes(Collection<Route> var1);

        public Builder routes(Route ... var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder vpcId(String var1);
    }
}

